/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.httpdlog.ApacheHttpdLoglineParser;

@Plugin(type="directive")
@Name(value="parse-as-log")
@Categories(categories={"parser", "logs"})
@Description(value="Parses Apache HTTPD and NGINX logs.")
public class ParseLog
implements Directive,
Lineage {
    public static final String NAME = "parse-as-log";
    private String column;
    private String format;
    private LogLine line;
    private Parser<Object> parser;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("format", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.format = ((Text)args.value("format")).value();
        this.parser = new ApacheHttpdLoglineParser(Object.class, this.format);
        this.line = new LogLine();
        List paths = this.parser.getPossiblePaths();
        try {
            this.parser.addParseTarget(LogLine.class.getMethod("setValue", String.class, String.class), paths);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            String log;
            int idx = row.find(this.column);
            if (idx == -1) continue;
            Object object = row.getValue(idx);
            if (object == null) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String' or 'byte array'.", this.column));
            }
            if (object instanceof String) {
                log = (String)object;
            } else if (object instanceof byte[]) {
                log = new String((byte[])object);
            } else {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String' or 'byte array'.", this.column, object.getClass().getSimpleName()));
            }
            this.line.set(row);
            try {
                this.parser.parse((Object)this.line, log);
            }
            catch (Exception e) {
                row.addOrSet("log.parse.error", (Object)1);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as webserver log using format '%s'", new Object[]{this.column, this.format}).all(Many.columns((String[])new String[]{this.column}), Many.columns((String[])new String[]{this.column})).build();
    }

    public final class LogLine {
        private Row row;

        public void setValue(String name, String value) {
            String key = name.toLowerCase();
            if (key.contains("original") || key.contains("bytesclf") || key.contains("cookie")) {
                return;
            }
            key = key.replaceAll("[^a-zA-Z0-9_]", "_");
            this.row.addOrSet(key, (Object)value);
        }

        public void set(Row row) {
            this.row = row;
        }

        public Row get() {
            return this.row;
        }
    }
}

