/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

@Plugin(type="directive")
@Name(value="parse-as-date")
@Categories(categories={"parser", "date"})
@Description(value="Parses column values as dates using natural language processing and automatically identifying the format (expensive in terms of time consumed).")
public class ParseDate
implements Directive,
Lineage {
    public static final String NAME = "parse-as-date";
    private String column;
    private TimeZone timezone;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("timezone", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.timezone = args.contains("timezone") ? TimeZone.getTimeZone(((Text)args.value("timezone")).value()) : TimeZone.getTimeZone("UTC");
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as date with timezone '%s'", new Object[]{this.column, this.timezone}).all(Many.columns((String[])new String[]{this.column}), Many.columns((String[])new String[]{this.column})).build();
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || (object = row.getValue(idx)) == null || object instanceof ZonedDateTime) continue;
            if (object instanceof String) {
                Parser parser = new Parser(this.timezone);
                List groups = parser.parse((String)object);
                int i = 1;
                for (DateGroup group : groups) {
                    List dates = group.getDates();
                    for (Date date : dates) {
                        row.add(String.format("%s_%d", this.column, i), (Object)date.toInstant().atZone(this.timezone.toZoneId()));
                    }
                    ++i;
                }
                continue;
            }
            throw new ErrorRowException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()), 1);
        }
        return rows;
    }
}

