/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import com.google.gson.Gson;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.util.Utf8;

@Plugin(type="directive")
@Name(value="parse-as-avro-file")
@Categories(categories={"parser", "avro"})
@Description(value="parse-as-avro-file <column>.")
public class ParseAvroFile
implements Directive,
Lineage {
    public static final String NAME = "parse-as-avro-file";
    private String column;
    private Gson gson;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.gson = new Gson();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx == -1) continue;
            Object object = row.getValue(idx);
            if (object instanceof byte[]) {
                DataFileReader reader = null;
                try {
                    reader = new DataFileReader((SeekableInput)new SeekableByteArrayInput((byte[])object), (DatumReader)new GenericDatumReader());
                    while (reader.hasNext()) {
                        Row newRow = new Row();
                        this.add((GenericRecord)reader.next(), newRow, null);
                        results.add(newRow);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new DirectiveExecutionException(NAME, "Failed to parse Avro data file. " + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (reader == null) continue;
                    try {
                        reader.close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type. It should be of type 'byte array'.", this.column));
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as a Avro file", new Object[]{this.column}).all(Many.columns((String[])new String[]{this.column})).build();
    }

    private void add(GenericRecord genericRecord, Row row, String name) {
        List fields = genericRecord.getSchema().getFields();
        for (Schema.Field field : fields) {
            Object v = genericRecord.get(field.name());
            String colname = name != null ? String.format("%s_%s", name, field.name()) : field.name();
            if (v instanceof GenericRecord) {
                this.add((GenericRecord)v, row, colname);
                continue;
            }
            if (v instanceof Map || v instanceof List) {
                row.add(colname, (Object)this.gson.toJson(v));
                continue;
            }
            if (v instanceof Utf8) {
                row.add(colname, (Object)v.toString());
                continue;
            }
            row.add(colname, genericRecord.get(field.name()));
        }
    }
}

