/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.dq.TypeInference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

@Plugin(type="directive")
@Name(value="parse-as-json")
@Categories(categories={"parser", "json"})
@Description(value="Parses a column as JSON.")
public class JsParser
implements Directive,
Lineage {
    public static final String NAME = "parse-as-json";
    private String column;
    private int depth;
    private static final JsonParser parser = new JsonParser();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("depth", TokenType.NUMERIC, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.depth = args.contains("depth") ? ((Numeric)args.value("depth")).value().intValue() : Integer.MAX_VALUE;
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            Object value;
            int idx = row.find(this.column);
            if (idx == -1 || (value = row.getValue(idx)) == null) continue;
            try {
                JsonElement element = null;
                if (value instanceof String) {
                    String document = (String)value;
                    element = parser.parse(document.trim());
                } else if (value instanceof JsonObject || value instanceof JsonArray) {
                    element = (JsonElement)value;
                } else {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String' or 'JsonObject' or 'JsonArray'.", this.column, value.getClass().getSimpleName()));
                }
                row.remove(idx);
                if (element == null) continue;
                if (element instanceof JsonObject) {
                    JsParser.jsonFlatten(element.getAsJsonObject(), this.column, 1, this.depth, row);
                    results.add(row);
                    continue;
                }
                if (element instanceof JsonArray) {
                    JsonArray array = element.getAsJsonArray();
                    if (array.size() > 0) {
                        for (int i = 0; i < array.size(); ++i) {
                            JsonElement object = array.get(i);
                            Row newRow = new Row(row);
                            newRow.add(this.column, JsParser.getValue(object));
                            results.add(newRow);
                        }
                        continue;
                    }
                    results.add(row);
                    continue;
                }
                if (!(element instanceof JsonPrimitive)) continue;
                row.add(this.column, JsParser.getValue(element.getAsJsonPrimitive()));
            }
            catch (JSONException e) {
                throw new ErrorRowException(NAME, e.getMessage(), 1);
            }
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as Json", new Object[]{this.column}).all(Many.columns((String[])new String[]{this.column})).build();
    }

    public static void jsonFlatten(JsonObject root, String field, int depth, int maxDepth, Row row) {
        if (depth > maxDepth) {
            row.addOrSet(String.format("%s", field), (Object)root);
            return;
        }
        for (Map.Entry next : root.entrySet()) {
            String key = (String)next.getKey();
            JsonElement element = (JsonElement)next.getValue();
            if (element instanceof JsonObject) {
                JsParser.jsonFlatten(element.getAsJsonObject(), String.format("%s_%s", field, key), depth + 1, maxDepth, row);
                continue;
            }
            row.add(String.format("%s_%s", field, key), JsParser.getValue(element));
        }
    }

    public static Object getValue(JsonElement element) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject();
        }
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        if (element.isJsonPrimitive()) {
            return JsParser.getValue(element.getAsJsonPrimitive());
        }
        return element.getAsJsonNull();
    }

    public static Object getValue(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            Number number = primitive.getAsNumber();
            if (number instanceof Long) {
                return number.longValue();
            }
            if (number instanceof Double) {
                return number.doubleValue();
            }
            if (number instanceof Integer) {
                return number.intValue();
            }
            if (number instanceof Short) {
                return number.shortValue();
            }
            if (number instanceof Float) {
                return Float.valueOf(number.floatValue());
            }
            if (number instanceof BigInteger) {
                return primitive.getAsBigInteger().longValue();
            }
            if (number instanceof BigDecimal) {
                return primitive.getAsBigDecimal().doubleValue();
            }
            if (number instanceof LazilyParsedNumber) {
                if (TypeInference.isInteger(primitive.getAsString())) {
                    return primitive.getAsBigInteger().longValue();
                }
                return primitive.getAsBigDecimal().doubleValue();
            }
        } else {
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isJsonNull()) {
                return primitive.getAsJsonNull();
            }
        }
        return null;
    }
}

