/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.LazyNumber;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.NumericList;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="parse-as-fixed-length")
@Categories(categories={"parser"})
@Description(value="Parses fixed-length records using the specified widths and padding-character.")
public final class FixedLengthParser
implements Directive,
Lineage {
    public static final String NAME = "parse-as-fixed-length";
    private int[] widths;
    private String col;
    private String padding;
    private int recordLength;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("width", TokenType.NUMERIC_LIST);
        builder.define("padding", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col = ((ColumnName)args.value("column")).value();
        List numbers = ((NumericList)args.value("width")).value();
        this.widths = new int[numbers.size()];
        int sum = 0;
        for (int idx = 0; idx < numbers.size(); ++idx) {
            this.widths[idx] = ((LazyNumber)numbers.get(idx)).intValue();
            sum += this.widths[idx];
        }
        this.recordLength = sum;
        this.padding = args.contains("padding") ? ((Text)args.value("padding")).value() : null;
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            int idx = row.find(this.col);
            if (idx == -1) continue;
            Object object = row.getValue(idx);
            if (object == null) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String'.", this.col));
            }
            if (object instanceof String) {
                String data = (String)object;
                int length = data.length();
                if (length < this.recordLength) {
                    throw new ErrorRowException(NAME, String.format("Column '%s' contains a value with fewer characters than the specified length of row. Expected at least %d characters but found %s characters.", this.col, this.recordLength, length), 2);
                }
                int index = 1;
                while (index + this.recordLength - 1 <= length) {
                    Row newRow = new Row(row);
                    int recPosition = index;
                    int colid = 1;
                    for (int width : this.widths) {
                        String val = data.substring(recPosition - 1, recPosition + width - 1);
                        if (this.padding != null) {
                            val = val.replaceAll(this.padding, "");
                        }
                        newRow.add(String.format("%s_%d", this.col, colid), (Object)val);
                        recPosition += width;
                        ++colid;
                    }
                    results.add(newRow);
                    index += this.recordLength;
                }
                continue;
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.col, object.getClass().getSimpleName()));
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' with fixed lengths for columns", new Object[]{this.col}).all(Many.of((String[])new String[]{this.col}), Many.of((String[])new String[]{this.col})).build();
    }
}

