/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.lookup;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.DatasetInstantiationException;
import io.cdap.cdap.etl.api.Lookup;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Plugin(type="directive")
@Name(value="table-lookup")
@Categories(categories={"lookup"})
@Description(value="Uses the given column as a key to perform a lookup into the specified table.")
public class TableLookup
implements Directive,
Lineage {
    public static final String NAME = "table-lookup";
    private String column;
    private String table;
    private boolean initialized;
    private io.cdap.cdap.etl.api.lookup.TableLookup tableLookup;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("table", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.table = ((Text)args.value("table")).value();
        this.initialized = false;
    }

    public void destroy() {
    }

    private void ensureInitialized(ExecutorContext context) throws DirectiveExecutionException {
        Lookup lookup;
        if (this.initialized) {
            return;
        }
        try {
            lookup = context.provide(this.table, Collections.emptyMap());
        }
        catch (DatasetInstantiationException e) {
            throw new DirectiveExecutionException(NAME, String.format("Dataset '%s' could not be instantiated. Make sure that a dataset '%s' of type Table exists.", this.table, this.table), (Throwable)e);
        }
        if (!(lookup instanceof io.cdap.cdap.etl.api.lookup.TableLookup)) {
            throw new DirectiveExecutionException(NAME, "Lookup is not being performed on a table. Lookup can be performed only on tables.");
        }
        this.tableLookup = (io.cdap.cdap.etl.api.lookup.TableLookup)lookup;
        this.initialized = true;
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        this.ensureInitialized(context);
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx == -1) continue;
            Object object = row.getValue(idx);
            if (object == null) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String'.", this.column));
            }
            if (!(object instanceof String)) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()));
            }
            io.cdap.cdap.api.dataset.table.Row lookedUpRow = this.tableLookup.lookup((String)object);
            for (Map.Entry entry : lookedUpRow.getColumns().entrySet()) {
                row.add(this.column + "_" + Bytes.toString((byte[])((byte[])entry.getKey())), (Object)Bytes.toString((byte[])((byte[])entry.getValue())));
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Looking up row in table '%s' based on column '%s'", new Object[]{this.table, this.column}).all(Many.of((String[])new String[]{this.column})).build();
    }
}

