/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.lookup;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.directives.lookup.StaticCatalog;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.executor.ICDCatalog;
import java.util.List;

@Plugin(type="directive")
@Name(value="catalog-lookup")
@Categories(categories={"lookup"})
@Description(value="Looks-up values from pre-loaded (static) catalogs.")
public class CatalogLookup
implements Directive,
Lineage {
    public static final String NAME = "catalog-lookup";
    private StaticCatalog catalog;
    private String name;
    private String column;
    private String generatedColumn;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("catalog", TokenType.TEXT);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        String type = ((Text)args.value("catalog")).value();
        if (!(type.equalsIgnoreCase("ICD-9") || type.equalsIgnoreCase("ICD-10-2016") || type.equalsIgnoreCase("ICD-10-2017"))) {
            throw new DirectiveParseException(NAME, "Invalid ICD type - should be 9 (ICD-9) or 10 (ICD-10-2016 or ICD-10-2017).");
        }
        this.catalog = new ICDCatalog(type.toLowerCase());
        if (!this.catalog.configure()) {
            throw new DirectiveParseException(NAME, "Failed to configure ICD StaticCatalog. Check with your administrator");
        }
        this.name = this.catalog.getCatalog().replaceAll("-", "_");
        this.generatedColumn = String.format("%s_%s_description", this.column, this.name);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                Object object = row.getValue(idx);
                if (object != null && object instanceof String) {
                    String code = (String)object;
                    StaticCatalog.Entry value = this.catalog.lookup(code);
                    if (value != null) {
                        row.add(this.generatedColumn, (Object)value.getDescription());
                        continue;
                    }
                    row.add(this.generatedColumn, null);
                    continue;
                }
                row.add(this.generatedColumn, null);
                continue;
            }
            row.add(this.generatedColumn, null);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Looked up catalog using value in column '%s' and wrote it to column '%s'", new Object[]{this.column, this.generatedColumn}).relation(this.column, Many.of((String[])new String[]{this.column, this.generatedColumn})).build();
    }
}

