/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.external;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@Plugin(type="directive")
@Name(value="invoke-http")
@Categories(categories={"http"})
@Description(value="Invokes an HTTP endpoint, passing columns as a JSON map (potentially slow).")
public class InvokeHttp
implements Directive,
Lineage {
    public static final String NAME = "invoke-http";
    private String url;
    private List<String> columns;
    private Gson gson;
    private Map<String, String> headers = new HashMap<String, String>();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("url", TokenType.TEXT);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        builder.define("header", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.gson = new Gson();
        this.url = ((Text)args.value("url")).value();
        this.columns = ((ColumnNameList)args.value("column")).value();
        String hdrs = null;
        if (args.contains("header")) {
            hdrs = ((Text)args.value("header")).value();
        }
        if (hdrs != null && !hdrs.isEmpty()) {
            String[] parsedHeaders;
            for (String header : parsedHeaders = hdrs.split(",")) {
                String[] components = header.split("=");
                if (components.length != 2) {
                    throw new DirectiveParseException(NAME, String.format("Incorrect header '%s' specified. Header should be specified as 'key=value' pairs separated by a comma (,).", header));
                }
                String key = components[0].trim();
                String value = components[1].trim();
                if (key.isEmpty()) {
                    throw new DirectiveParseException(NAME, String.format("Key specified for header '%s' cannot be empty.", header));
                }
                if (value.isEmpty()) {
                    throw new DirectiveParseException(NAME, String.format("Value specified for header '%s' cannot be empty.", header));
                }
                this.headers.put(key, value);
            }
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (String column : this.columns) {
                int idx = row.find(column);
                if (idx == -1) continue;
                parameters.put(column, row.getValue(idx));
            }
            try {
                Map<String, Object> result = this.invokeHttp(this.url, parameters, this.headers);
                for (Map.Entry<String, Object> entry : result.entrySet()) {
                    row.addOrSet(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                throw new ErrorRowException(NAME, e.getMessage(), 500);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Invoked external service '%s' to enrich row based on columns '%s'", new Object[]{this.url, this.columns}).all(Many.of(this.columns), Many.of(this.columns)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> invokeHttp(String url, Map<String, Object> parameters, Map<String, String> headers) throws IOException {
        try (CloseableHttpClient client = null;){
            String body = this.gson.toJson(parameters);
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-type", "application/json; charset=UTF-8");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
            BasicHttpEntity entity = new BasicHttpEntity();
            ByteArrayInputStream stream = new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
            entity.setContent((InputStream)stream);
            post.setEntity((HttpEntity)entity);
            client = HttpClients.createDefault();
            Map map = (Map)client.execute((HttpUriRequest)post, (ResponseHandler)new ServiceResponseHandler());
            return map;
        }
    }

    private class ServiceResponseHandler
    implements ResponseHandler<Map<String, Object>> {
        private ServiceResponseHandler() {
        }

        public Map<String, Object> handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            Gson gson = new GsonBuilder().create();
            InputStreamReader reader = new InputStreamReader(entity.getContent(), Charset.forName("UTF-8"));
            return (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
        }
    }
}

