/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.currency;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;

@Plugin(type="directive")
@Name(value="format-as-currency")
@Categories(categories={"currency"})
@Description(value="Formats a number as currency using the locale specified. Default locale is en_US.")
public class FormatAsCurrency
implements Directive,
Lineage {
    public static final String NAME = "format-as-currency";
    private String source;
    private String destination;
    private String locale;
    private NumberFormat format;
    private Locale lcl;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define("locale", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.source = ((ColumnName)args.value("source")).value();
        this.destination = ((ColumnName)args.value("destination")).value();
        this.locale = args.contains("locale") ? ((Text)args.value("locale")).value() : "en_US";
        this.lcl = LocaleUtils.toLocale((String)this.locale);
        this.format = NumberFormat.getCurrencyInstance(this.lcl);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.source);
            if (idx == -1 || (object = row.getValue(idx)) == null || !(object instanceof Double)) continue;
            Double value = (Double)object;
            String format = this.format.format(value);
            row.addOrSet(this.destination, (Object)format);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Formatted column '%s' to currency locale '%s' into '%s'", new Object[]{this.source, this.destination, this.locale}).conditional(this.source, this.destination).build();
    }
}

