/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

@Plugin(type="directive")
@Name(value="merge")
@Categories(categories={"column"})
@Description(value="Merges values from two columns using a separator into a new column.")
public class Merge
implements Directive,
Lineage {
    public static final String NAME = "merge";
    private String col1;
    private String col2;
    private String dest;
    private String delimiter;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column1", TokenType.COLUMN_NAME);
        builder.define("column2", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define("separator", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col1 = ((ColumnName)args.value("column1")).value();
        this.col2 = ((ColumnName)args.value("column2")).value();
        this.dest = ((ColumnName)args.value("destination")).value();
        this.delimiter = ((Text)args.value("separator")).value();
        this.delimiter = StringEscapeUtils.unescapeJava((String)this.delimiter);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            int idx1 = row.find(this.col1);
            int idx2 = row.find(this.col2);
            if (idx1 != -1 && idx2 != -1) {
                StringBuilder builder = new StringBuilder();
                builder.append(row.getValue(idx1));
                builder.append(this.delimiter);
                builder.append(row.getValue(idx2));
                row.add(this.dest, (Object)builder.toString());
            }
            results.add(row);
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Merged column '%s' and '%s' using delimiter '%s' into column '%s'", new Object[]{this.col1, this.col2, this.delimiter, this.dest}).relation(Many.columns((String[])new String[]{this.col1, this.col2}), Many.of((String[])new String[]{this.col1, this.col2, this.dest})).build();
    }
}

