/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Plugin(type="directive")
@Name(value="keep")
@Categories(categories={"column"})
@Description(value="Keeps the specified columns and drops all others.")
public class Keep
implements Directive,
Lineage {
    public static final String NAME = "keep";
    private final Set<String> keep = new HashSet<String>();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        ColumnNameList cols = (ColumnNameList)args.value("column");
        for (String col : cols.value()) {
            this.keep.add(col);
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = 0;
            for (Pair v : row.getFields()) {
                if (!this.keep.contains(v.getFirst())) {
                    row.remove(idx);
                    continue;
                }
                ++idx;
            }
        }
        return rows;
    }

    public Mutation lineage() {
        Mutation.Builder builder = Mutation.builder().readable("Removed all columns except '%s'", new Object[]{this.keep});
        this.keep.forEach(column -> builder.relation(column, column));
        return builder.build();
    }
}

