/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;

@Plugin(type="directive")
@Name(value="cleanse-column-names")
@Categories(categories={"column"})
@Description(value="Sanatizes column names: trims, lowercases, and replaces all but [A-Z][a-z][0-9]_.with an underscore '_'.")
public final class CleanseColumnNames
implements Directive,
Lineage {
    public static final String NAME = "cleanse-column-names";

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            for (int i = 0; i < row.width(); ++i) {
                String column = row.getColumn(i);
                column = column.trim();
                column = column.toLowerCase();
                column = column.replaceAll("[^a-zA-Z0-9_]", "_");
                row.setColumn(i, column);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Sanitized all column names: trimmed sides, lower-cased, and replaced all but [A-Z][a-z][0-9]_ characters", new Object[0]).all(Many.of((String[])new String[0])).build();
    }
}

