/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Row;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class StructuredToRowTransformer {
    private StructuredToRowTransformer() {
    }

    public static Row transform(StructuredRecord record) {
        Row row = new Row();
        for (Schema.Field field : record.getSchema().getFields()) {
            row.add(field.getName(), StructuredToRowTransformer.getValue(record, field.getName()));
        }
        return row;
    }

    @Nullable
    public static Object getValue(StructuredRecord input, String fieldName) {
        Schema fieldSchema = input.getSchema().getField(fieldName).getSchema();
        fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
        Schema.LogicalType logicalType = fieldSchema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType) {
                case DATE: {
                    return input.getDate(fieldName);
                }
                case TIME_MILLIS: 
                case TIME_MICROS: {
                    return input.getTime(fieldName);
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return input.getTimestamp(fieldName);
                }
                case DECIMAL: {
                    return input.getDecimal(fieldName);
                }
                case DATETIME: {
                    return input.getDateTime(fieldName);
                }
            }
            throw new UnexpectedFormatException("Field type " + logicalType + " is not supported.");
        }
        Object val = input.get(fieldName);
        return StructuredToRowTransformer.processValue(val, fieldSchema, fieldName);
    }

    @Nullable
    private static Object processValue(@Nullable Object val, Schema schema, String fieldName) {
        if (val == null) {
            return null;
        }
        switch (schema.getType()) {
            case BYTES: {
                return val instanceof ByteBuffer ? (Object)Bytes.toBytes((ByteBuffer)((ByteBuffer)val)) : val;
            }
            case RECORD: {
                return StructuredToRowTransformer.transform((StructuredRecord)val);
            }
            case ARRAY: {
                if (val instanceof Iterable) {
                    ArrayList<Object> rowList = new ArrayList<Object>();
                    for (Object item : (Iterable)val) {
                        if (item != null && schema.getComponentSchema() != null) {
                            rowList.add(StructuredToRowTransformer.processValue(item, schema.getComponentSchema(), fieldName));
                            continue;
                        }
                        rowList.add(item);
                    }
                    return rowList;
                }
                throw new IllegalArgumentException("Field " + fieldName + " expected an array but received an invalid value");
            }
        }
        return val;
    }
}

