/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import java.util.regex.Pattern;

public class ReferenceNames {
    private static final Pattern DATASET_PATTERN = Pattern.compile("[$\\.a-zA-Z0-9_-]+");
    private static final String REGEX = "[^$\\.a-zA-Z0-9_-]+";

    private ReferenceNames() {
    }

    public static void validate(String referenceName) {
        if (!DATASET_PATTERN.matcher(referenceName).matches()) {
            throw new IllegalArgumentException(String.format("Invalid reference name '%s'. Supported characters are: letters, numbers, and '_', '-', '.', or '$'.", referenceName));
        }
    }

    public static String cleanseReferenceName(String referenceName) {
        String result = referenceName.replaceAll(REGEX, "");
        return result.isEmpty() ? "sample" : result;
    }
}

