/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectInfo.class);
    private static final String RESOURCE_NAME = "/.properties";
    private static final String PLUGIN_VERSION = "plugin.version";
    private static final Map<String, String> PROPERTIES;

    public static Map<String, String> getProperties() {
        return PROPERTIES;
    }

    public static String getVersion() {
        return PROPERTIES.get(PLUGIN_VERSION);
    }

    static {
        Properties props = new Properties();
        try {
            InputStream resourceStream = ProjectInfo.class.getResourceAsStream(RESOURCE_NAME);
            Object object = null;
            try {
                props.load(resourceStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (resourceStream != null) {
                    if (object != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        resourceStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to load the project properties {} ", (Object)e.getMessage(), (Object)e);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            properties.put(key, props.getProperty(key));
        }
        PROPERTIES = properties;
    }
}

