/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonPathGenerator {
    private final JsonParser parser = new JsonParser();

    public List<String> get(String json) {
        if (json == null || json.isEmpty()) {
            return new ArrayList<String>();
        }
        JsonElement object = this.parser.parse(json);
        return this.get(object);
    }

    public List<String> get(JsonElement object) {
        ArrayList<String> paths = new ArrayList<String>();
        String root = "$";
        if (object.isJsonObject()) {
            paths.addAll(this.readObject(object.getAsJsonObject(), root));
        } else if (object.isJsonArray()) {
            paths.addAll(this.readArray(object.getAsJsonArray(), root));
        }
        return paths;
    }

    private List<String> readObject(JsonObject object, String parent) {
        ArrayList<String> paths = new ArrayList<String>();
        Set entries = object.entrySet();
        Iterator iterator = entries.iterator();
        paths.add(parent);
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            String base = parent + "." + (String)next.getKey();
            JsonElement element = (JsonElement)next.getValue();
            if (element.isJsonObject()) {
                paths.addAll(this.readObject(element.getAsJsonObject(), base));
                continue;
            }
            if (element.isJsonArray()) {
                paths.addAll(this.readArray(element.getAsJsonArray(), base));
                continue;
            }
            paths.add(base);
        }
        return paths;
    }

    private List<String> readArray(JsonArray array, String path) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        String parent = path;
        for (int i = 0; i < array.size(); ++i) {
            JsonElement value = array.get(i);
            path = parent + "[" + i + "]";
            if (value.isJsonArray()) {
                paths.addAll(this.readArray(value.getAsJsonArray(), path));
                continue;
            }
            if (value.isJsonObject()) {
                paths.addAll(this.readObject(value.getAsJsonObject(), path));
                continue;
            }
            paths.add(path);
        }
        return paths;
    }
}

