/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.Row;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ColumnConverter {
    private static final Map<String, Schema.Type> SCHEMA_TYPE_MAP;

    private ColumnConverter() {
    }

    public static void rename(String directiveName, Row row, String column, String toName) throws DirectiveExecutionException {
        int idx = row.find(column);
        int existingColumn = row.find(toName);
        if (idx == -1) {
            return;
        }
        if (existingColumn != -1 && idx != existingColumn) {
            throw new DirectiveExecutionException(directiveName, String.format("Column '%s' already exists. Apply the 'drop %s' directive before renaming '%s' to '%s'.", toName, toName, column, toName));
        }
        row.setColumn(idx, toName);
    }

    public static void convertType(String directiveName, Row row, String column, String toType, Integer scale, RoundingMode roundingMode) throws DirectiveExecutionException {
        int idx = row.find(column);
        if (idx != -1) {
            Object object = row.getValue(idx);
            if (object == null || object instanceof String && ((String)object).trim().isEmpty()) {
                return;
            }
            try {
                Object converted = ColumnConverter.convertType(column, toType, object);
                if (toType.equalsIgnoreCase("DECIMAL")) {
                    row.setValue(idx, (Object)ColumnConverter.setDecimalScale((BigDecimal)converted, scale, roundingMode));
                } else {
                    row.setValue(idx, converted);
                }
            }
            catch (DirectiveExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DirectiveExecutionException(directiveName, String.format("Column '%s' cannot be converted to a '%s'.", column, toType), (Throwable)e);
            }
        }
    }

    private static Object convertType(String col, String toType, Object object) throws Exception {
        switch (toType = toType.toUpperCase()) {
            case "INTEGER": 
            case "I64": 
            case "INT": {
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).intValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).intValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).intValue();
                }
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Long) {
                    return ((Long)object).intValue();
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).intValue();
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toInt((byte[])((byte[])object));
            }
            case "I32": 
            case "SHORT": {
                if (object instanceof String) {
                    return Short.parseShort((String)object);
                }
                if (object instanceof Short) {
                    return object;
                }
                if (object instanceof Float) {
                    return ((Float)object).shortValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).shortValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).shortValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).shortValue();
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).shortValue();
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toShort((byte[])((byte[])object));
            }
            case "LONG": {
                if (object instanceof String) {
                    return Long.parseLong((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).longValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).longValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).longValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object instanceof Long) {
                    return object;
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).longValue();
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toLong((byte[])((byte[])object));
            }
            case "BOOL": 
            case "BOOLEAN": {
                if (object instanceof Boolean) {
                    return object;
                }
                if (object instanceof String) {
                    return Boolean.parseBoolean((String)object);
                }
                if (object instanceof Short) {
                    return (Short)object > 0;
                }
                if (object instanceof Float) {
                    return ((Float)object).floatValue() > 0.0f;
                }
                if (object instanceof Double) {
                    return (Double)object > 0.0;
                }
                if (object instanceof Integer) {
                    return (Integer)object > 0;
                }
                if (object instanceof Long) {
                    return (Long)object > 0L;
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).compareTo(BigDecimal.ZERO) > 0;
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toBoolean((byte[])((byte[])object));
            }
            case "STRING": {
                if (object instanceof byte[]) {
                    return Bytes.toString((byte[])((byte[])object));
                }
                return object.toString();
            }
            case "FLOAT": {
                if (object instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)object));
                }
                if (object instanceof Short) {
                    return Float.valueOf(((Short)object).floatValue());
                }
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Double) {
                    return Float.valueOf(((Double)object).floatValue());
                }
                if (object instanceof Integer) {
                    return Float.valueOf(((Integer)object).floatValue());
                }
                if (object instanceof Long) {
                    return Float.valueOf(((Long)object).floatValue());
                }
                if (object instanceof BigDecimal) {
                    return Float.valueOf(((BigDecimal)object).floatValue());
                }
                if (!(object instanceof byte[])) break;
                return Float.valueOf(Bytes.toFloat((byte[])((byte[])object)));
            }
            case "DECIMAL": {
                if (object instanceof BigDecimal) {
                    return object;
                }
                if (object instanceof String) {
                    return new BigDecimal((String)object);
                }
                if (object instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)object).intValue());
                }
                if (object instanceof Short) {
                    return BigDecimal.valueOf(((Short)object).shortValue());
                }
                if (object instanceof Long) {
                    return BigDecimal.valueOf((Long)object);
                }
                if (object instanceof Float) {
                    return BigDecimal.valueOf(((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return BigDecimal.valueOf((Double)object);
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toBigDecimal((byte[])((byte[])object));
            }
            case "DOUBLE": {
                if (object instanceof String) {
                    return Double.parseDouble((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).doubleValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).doubleValue();
                }
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Integer) {
                    return ((Integer)object).doubleValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).doubleValue();
                }
                if (object instanceof byte[]) {
                    return Bytes.toDouble((byte[])((byte[])object));
                }
                if (!(object instanceof BigDecimal)) break;
                return ((BigDecimal)object).doubleValue();
            }
            case "BYTES": {
                if (object instanceof String) {
                    return Bytes.toBytes((String)((String)object));
                }
                if (object instanceof Short) {
                    return Bytes.toBytes((short)((Short)object));
                }
                if (object instanceof Float) {
                    return Bytes.toBytes((float)((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return Bytes.toBytes((double)((Double)object));
                }
                if (object instanceof Integer) {
                    return Bytes.toBytes((int)((Integer)object));
                }
                if (object instanceof Long) {
                    return Bytes.toBytes((long)((Long)object));
                }
                if (object instanceof BigDecimal) {
                    return Bytes.toBytes((BigDecimal)((BigDecimal)object));
                }
                if (!(object instanceof byte[])) break;
                return object;
            }
            default: {
                throw new DirectiveExecutionException(String.format("Column '%s' is of unsupported type '%s'. Supported types are: int, short, long, double, decimal, boolean, string, bytes", col, toType));
            }
        }
        throw new DirectiveExecutionException(String.format("Column '%s' has value of type '%s' and cannot be converted to a '%s'.", col, object.getClass().getSimpleName(), toType));
    }

    private static BigDecimal setDecimalScale(BigDecimal decimal, Integer scale, RoundingMode roundingMode) throws DirectiveExecutionException {
        if (scale == null) {
            return decimal;
        }
        try {
            return decimal.setScale((int)scale, roundingMode);
        }
        catch (ArithmeticException e) {
            throw new DirectiveExecutionException(String.format("Cannot set scale as '%s' for value '%s' when rounding-mode is '%s'", new Object[]{scale, decimal, roundingMode}), (Throwable)e);
        }
    }

    public static Schema getSchemaForType(String type, Integer scale) throws DirectiveParseException {
        Schema typeSchema;
        if ((type = type.toUpperCase()).equals("DECIMAL")) {
            typeSchema = Schema.nullableOf((Schema)Schema.decimalOf((int)77, (int)scale));
        } else {
            if (!SCHEMA_TYPE_MAP.containsKey(type)) {
                throw new DirectiveParseException(String.format("'%s' is an unsupported type. Supported types are: int, short, long, double, decimal, boolean, string, bytes", type));
            }
            typeSchema = Schema.nullableOf((Schema)Schema.of((Schema.Type)SCHEMA_TYPE_MAP.get(type)));
        }
        return typeSchema;
    }

    static {
        HashMap<String, Schema.Type> schemaTypeMap = new HashMap<String, Schema.Type>();
        schemaTypeMap.put("INTEGER", Schema.Type.INT);
        schemaTypeMap.put("I64", Schema.Type.INT);
        schemaTypeMap.put("INT", Schema.Type.INT);
        schemaTypeMap.put("SHORT", Schema.Type.INT);
        schemaTypeMap.put("I32", Schema.Type.INT);
        schemaTypeMap.put("LONG", Schema.Type.LONG);
        schemaTypeMap.put("BOOL", Schema.Type.BOOLEAN);
        schemaTypeMap.put("BOOLEAN", Schema.Type.BOOLEAN);
        schemaTypeMap.put("STRING", Schema.Type.STRING);
        schemaTypeMap.put("FLOAT", Schema.Type.FLOAT);
        schemaTypeMap.put("DOUBLE", Schema.Type.DOUBLE);
        schemaTypeMap.put("BYTES", Schema.Type.BYTES);
        SCHEMA_TYPE_MAP = Collections.unmodifiableMap(schemaTypeMap);
    }

    private static final class ColumnTypeNames {
        public static final String INTEGER = "INTEGER";
        public static final String I64 = "I64";
        public static final String INT = "INT";
        public static final String SHORT = "SHORT";
        public static final String I32 = "I32";
        public static final String LONG = "LONG";
        public static final String BOOL = "BOOL";
        public static final String BOOLEAN = "BOOLEAN";
        public static final String STRING = "STRING";
        public static final String FLOAT = "FLOAT";
        public static final String DOUBLE = "DOUBLE";
        public static final String BYTES = "BYTES";
        public static final String DECIMAL = "DECIMAL";

        private ColumnTypeNames() {
            throw new AssertionError((Object)"Cannot instantiate a constants class");
        }
    }
}

