/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.wrangler.api.DirectiveExecutionException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class ArithmeticOperations {
    private static NumberType getOutputType(Number ... nums) throws DirectiveExecutionException {
        NumberType outputType = NumberType.SHORT;
        for (Number num : nums) {
            if (num instanceof Byte) {
                throw new DirectiveExecutionException("Input cannot be of type 'Byte'.");
            }
            if (num == null) {
                return null;
            }
            if (num instanceof Integer && NumberType.INTEGER.getPriority() > outputType.getPriority()) {
                outputType = NumberType.INTEGER;
                continue;
            }
            if (num instanceof Long && NumberType.LONG.getPriority() > outputType.getPriority()) {
                outputType = NumberType.LONG;
                continue;
            }
            if (num instanceof Float && NumberType.FLOAT.getPriority() > outputType.getPriority()) {
                outputType = NumberType.FLOAT;
                continue;
            }
            if (num instanceof Double && NumberType.DOUBLE.getPriority() > outputType.getPriority()) {
                outputType = NumberType.DOUBLE;
                continue;
            }
            if (!(num instanceof BigDecimal)) continue;
            outputType = NumberType.BIGDECIMAL;
        }
        return outputType;
    }

    private static BigDecimal numberToBigDecimal(Number num) {
        return num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString());
    }

    public static Number add(Number ... nums) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(nums);
        if (outputType == null) {
            return null;
        }
        switch (outputType) {
            case SHORT: {
                short shortSum = 0;
                for (Number num : nums) {
                    shortSum = (short)(shortSum + num.shortValue());
                }
                return shortSum;
            }
            case INTEGER: {
                int intSum = 0;
                for (Number num : nums) {
                    intSum += num.intValue();
                }
                return intSum;
            }
            case LONG: {
                long longSum = 0L;
                for (Number num : nums) {
                    longSum += num.longValue();
                }
                return longSum;
            }
            case FLOAT: {
                float floatSum = 0.0f;
                for (Number num : nums) {
                    floatSum += num.floatValue();
                }
                return Float.valueOf(floatSum);
            }
            case DOUBLE: {
                double doubleSum = 0.0;
                for (Number num : nums) {
                    doubleSum += num.doubleValue();
                }
                return doubleSum;
            }
        }
        BigDecimal bdSum = BigDecimal.valueOf(0L);
        for (Number num : nums) {
            bdSum = bdSum.add(ArithmeticOperations.numberToBigDecimal(num));
        }
        return bdSum.stripTrailingZeros();
    }

    public static Number minus(Number x, Number y) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(x, y);
        if (outputType == null) {
            return null;
        }
        switch (outputType) {
            case SHORT: {
                return (short)(x.shortValue() - y.shortValue());
            }
            case INTEGER: {
                return x.intValue() - y.intValue();
            }
            case LONG: {
                return x.longValue() - y.longValue();
            }
            case FLOAT: {
                return Float.valueOf(x.floatValue() - y.floatValue());
            }
            case DOUBLE: {
                return x.doubleValue() - y.doubleValue();
            }
        }
        BigDecimal bdX = ArithmeticOperations.numberToBigDecimal(x);
        BigDecimal bdY = ArithmeticOperations.numberToBigDecimal(y);
        return bdX.subtract(bdY).stripTrailingZeros();
    }

    public static Number multiply(Number ... nums) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(nums);
        if (outputType == null) {
            return null;
        }
        switch (outputType) {
            case SHORT: {
                short shortProd = 1;
                for (Number num : nums) {
                    shortProd = (short)(shortProd * num.shortValue());
                }
                return shortProd;
            }
            case INTEGER: {
                int intProd = 1;
                for (Number num : nums) {
                    intProd *= num.intValue();
                }
                return intProd;
            }
            case LONG: {
                long longProd = 1L;
                for (Number num : nums) {
                    longProd *= num.longValue();
                }
                return longProd;
            }
            case FLOAT: {
                float floatProd = 1.0f;
                for (Number num : nums) {
                    floatProd *= num.floatValue();
                }
                return Float.valueOf(floatProd);
            }
            case DOUBLE: {
                double doubleProd = 1.0;
                for (Number num : nums) {
                    doubleProd *= num.doubleValue();
                }
                return doubleProd;
            }
        }
        BigDecimal bdProd = BigDecimal.valueOf(1L);
        for (Number num : nums) {
            bdProd = bdProd.multiply(ArithmeticOperations.numberToBigDecimal(num));
        }
        return bdProd;
    }

    public static Number divideq(Number x, Number y) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(x, y);
        if (outputType == null || y.doubleValue() == 0.0) {
            return null;
        }
        switch (outputType) {
            case BIGDECIMAL: {
                BigDecimal bdX = ArithmeticOperations.numberToBigDecimal(x);
                BigDecimal bdY = ArithmeticOperations.numberToBigDecimal(y);
                return bdX.divide(bdY, 6).stripTrailingZeros();
            }
        }
        return x.doubleValue() / y.doubleValue();
    }

    public static Number divider(Number x, Number y) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(x, y);
        if (outputType == null || y.doubleValue() == 0.0) {
            return null;
        }
        switch (outputType) {
            case SHORT: {
                return x.shortValue() % y.shortValue();
            }
            case INTEGER: {
                return x.intValue() % y.intValue();
            }
            case LONG: {
                return x.longValue() % y.longValue();
            }
            case FLOAT: {
                return Float.valueOf(x.floatValue() % y.floatValue());
            }
            case DOUBLE: {
                return x.doubleValue() % y.doubleValue();
            }
        }
        BigDecimal bdX = ArithmeticOperations.numberToBigDecimal(x);
        BigDecimal bdY = ArithmeticOperations.numberToBigDecimal(y);
        return bdX.remainder(bdY);
    }

    public static Number lcm(Number x, Number y) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(x, y);
        if (outputType == null) {
            return null;
        }
        BigDecimal bdX = ArithmeticOperations.numberToBigDecimal(x);
        BigDecimal bdY = ArithmeticOperations.numberToBigDecimal(y);
        switch (outputType) {
            case SHORT: {
                return ArithmeticOperations.lcm(bdX, bdY).shortValue();
            }
            case INTEGER: {
                return ArithmeticOperations.lcm(bdX, bdY).intValue();
            }
            case LONG: {
                return ArithmeticOperations.lcm(bdX, bdY).longValue();
            }
            case FLOAT: {
                return Float.valueOf(ArithmeticOperations.lcm(bdX, bdY).floatValue());
            }
            case DOUBLE: {
                return ArithmeticOperations.lcm(bdX, bdY).doubleValue();
            }
        }
        BigDecimal pow = BigDecimal.valueOf(Math.pow(10.0, Math.max(bdX.scale(), bdY.scale())));
        BigInteger val1 = bdX.multiply(pow).toBigInteger();
        BigInteger val2 = bdY.multiply(pow).toBigInteger();
        BigDecimal absProduct = new BigDecimal(val1.multiply(val2).abs()).setScale(Math.min(bdX.scale(), bdY.scale()), 6);
        BigDecimal gcd = new BigDecimal(val1.gcd(val2));
        if (gcd.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return absProduct.divide(gcd.multiply(pow), 6);
    }

    public static Boolean equal(Short ... nums) {
        for (Short num : nums) {
            if (num == null) {
                return null;
            }
            if (num.equals(nums[0])) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean equal(Integer ... nums) {
        for (Integer num : nums) {
            if (num == null) {
                return null;
            }
            if (num.equals(nums[0])) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean equal(Long ... nums) {
        for (Long num : nums) {
            if (num == null) {
                return null;
            }
            if (num.equals(nums[0])) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean equal(Float ... nums) {
        for (Float num : nums) {
            if (num == null) {
                return null;
            }
            if (num.equals(nums[0])) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean equal(Double ... nums) {
        for (Double num : nums) {
            if (num == null) {
                return null;
            }
            if (num.equals(nums[0])) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean equal(BigDecimal ... nums) {
        for (BigDecimal num : nums) {
            if (num == null) {
                return null;
            }
            if (num.equals(nums[0])) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Number max(Number ... nums) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(nums);
        if (outputType == null) {
            return null;
        }
        switch (outputType) {
            case SHORT: {
                short shortMax = nums[0].shortValue();
                for (Number num : nums) {
                    if (num.shortValue() <= shortMax) continue;
                    shortMax = num.shortValue();
                }
                return shortMax;
            }
            case INTEGER: {
                int intMax = nums[0].intValue();
                for (Number num : nums) {
                    if (num.intValue() <= intMax) continue;
                    intMax = num.intValue();
                }
                return intMax;
            }
            case LONG: {
                long longMax = nums[0].longValue();
                for (Number num : nums) {
                    if (num.longValue() <= longMax) continue;
                    longMax = num.longValue();
                }
                return longMax;
            }
            case FLOAT: {
                float floatMax = nums[0].floatValue();
                for (Number num : nums) {
                    if (!(num.floatValue() > floatMax)) continue;
                    floatMax = num.floatValue();
                }
                return Float.valueOf(floatMax);
            }
            case DOUBLE: {
                double doubleMax = nums[0].doubleValue();
                for (Number num : nums) {
                    if (!(num.doubleValue() > doubleMax)) continue;
                    doubleMax = num.doubleValue();
                }
                return doubleMax;
            }
        }
        BigDecimal bdMax = new BigDecimal(nums[0].toString());
        for (Number num : nums) {
            bdMax = bdMax.max(ArithmeticOperations.numberToBigDecimal(num));
        }
        return bdMax;
    }

    public static Number min(Number ... nums) throws DirectiveExecutionException {
        NumberType outputType = ArithmeticOperations.getOutputType(nums);
        if (outputType == null) {
            return null;
        }
        switch (outputType) {
            case SHORT: {
                short shortMin = nums[0].shortValue();
                for (Number num : nums) {
                    if (num.shortValue() >= shortMin) continue;
                    shortMin = num.shortValue();
                }
                return shortMin;
            }
            case INTEGER: {
                int intMin = nums[0].intValue();
                for (Number num : nums) {
                    if (num.intValue() >= intMin) continue;
                    intMin = num.intValue();
                }
                return intMin;
            }
            case LONG: {
                long longMin = nums[0].longValue();
                for (Number num : nums) {
                    if (num.longValue() >= longMin) continue;
                    longMin = num.longValue();
                }
                return longMin;
            }
            case FLOAT: {
                float floatMin = nums[0].floatValue();
                for (Number num : nums) {
                    if (!(num.floatValue() < floatMin)) continue;
                    floatMin = num.floatValue();
                }
                return Float.valueOf(floatMin);
            }
            case DOUBLE: {
                double doubleMin = nums[0].doubleValue();
                for (Number num : nums) {
                    if (!(num.doubleValue() < doubleMin)) continue;
                    doubleMin = num.doubleValue();
                }
                return doubleMin;
            }
        }
        BigDecimal bdMin = new BigDecimal(nums[0].toString());
        for (Number num : nums) {
            bdMin = bdMin.min(ArithmeticOperations.numberToBigDecimal(num));
        }
        return bdMin;
    }

    public static Number average(Number ... nums) throws DirectiveExecutionException {
        Number avg = 0.0;
        int t = 1;
        boolean allNull = true;
        boolean containsBigDecimal = false;
        for (Number num : nums) {
            if (num == null) continue;
            allNull = false;
            if (num instanceof Byte) {
                throw new DirectiveExecutionException("Input cannot be of type 'Byte'.");
            }
            if (!containsBigDecimal && num instanceof BigDecimal) {
                avg = t > 1 ? BigDecimal.valueOf((Double)avg) : BigDecimal.ZERO;
                containsBigDecimal = true;
            }
            if (containsBigDecimal) {
                BigDecimal numer = ArithmeticOperations.numberToBigDecimal(num).subtract((BigDecimal)avg);
                BigDecimal denom = BigDecimal.valueOf(t);
                avg = ((BigDecimal)avg).add(numer.divide(denom, RoundingMode.HALF_EVEN));
            } else {
                avg = (Double)avg + (num.doubleValue() - (Double)avg) / (double)t;
            }
            ++t;
        }
        if (allNull) {
            return null;
        }
        return avg;
    }

    private static enum NumberType {
        SHORT(0),
        INTEGER(1),
        LONG(2),
        FLOAT(3),
        DOUBLE(4),
        BIGDECIMAL(5);

        private final int priority;

        private NumberType(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

