/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.statistics;

import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.statistics.Measurements;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ColumnMetric {
    private final Map<String, Measurements> measures = new TreeMap<String, Measurements>();

    public void increment(String column, String measure) {
        Measurements metric = this.measures.containsKey(column) ? this.measures.get(column) : new Measurements();
        metric.increment(measure);
        this.measures.put(column, metric);
    }

    public void set(String column, String measure, double value) {
        Measurements metric = this.measures.containsKey(column) ? this.measures.get(column) : new Measurements();
        metric.set(measure, value);
        this.measures.put(column, metric);
    }

    public Set<String> getColumns() {
        return this.measures.keySet();
    }

    public List<Pair<String, Double>> percentage(String column, Double sum) {
        if (this.measures.containsKey(column)) {
            return this.measures.get(column).percentage(sum);
        }
        return new ArrayList<Pair<String, Double>>();
    }
}

