/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.statistics;

import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.statistics.ColumnMetric;
import io.cdap.wrangler.statistics.Statistics;
import io.dataapps.chlorine.finder.FinderEngine;
import java.util.List;
import java.util.Map;

public class BasicStatistics
implements Statistics {
    private static final long TIME_OUT_MILLIS = 10000L;
    private final FinderEngine engine = new FinderEngine("wrangler-finder.xml", true, false);

    @Override
    public Row aggregate(List<Row> rows) {
        ColumnMetric types = new ColumnMetric();
        ColumnMetric stats = new ColumnMetric();
        long startTime = System.currentTimeMillis();
        Double count = new Double(0.0);
        block0: for (Row row : rows) {
            count = count + 1.0;
            for (int i = 0; i < row.width(); ++i) {
                String column = row.getColumn(i);
                Object object = row.getValue(i);
                if (object == null) {
                    stats.increment(column, "null");
                } else {
                    stats.increment(column, "non-null");
                }
                if (!(object instanceof String)) continue;
                String value = (String)object;
                if (value.isEmpty()) {
                    stats.increment(column, "empty");
                    continue;
                }
                Map finds = this.engine.findWithType(value);
                for (String find : finds.keySet()) {
                    types.increment(column, find);
                }
                if (System.currentTimeMillis() - startTime > 10000L) continue block0;
            }
        }
        Row rowTypes = new Row();
        for (String column : types.getColumns()) {
            rowTypes.add(column, types.percentage(column, count));
        }
        Row row = new Row();
        for (String column : stats.getColumns()) {
            row.add(column, stats.percentage(column, count));
        }
        Row row2 = new Row();
        row2.add("types", (Object)rowTypes);
        row2.add("stats", (Object)row);
        row2.add("total", (Object)count);
        return row2;
    }
}

