/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.schema;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.SchemaResolutionContext;
import io.cdap.wrangler.utils.RecordConvertorException;
import io.cdap.wrangler.utils.SchemaConverter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DirectiveOutputSchemaGenerator {
    private final SchemaConverter schemaGenerator;
    private final Map<String, Object> outputFieldMap;
    private final Directive directive;

    public DirectiveOutputSchemaGenerator(Directive directive, SchemaConverter schemaGenerator) {
        this.directive = directive;
        this.schemaGenerator = schemaGenerator;
        this.outputFieldMap = new LinkedHashMap<String, Object>();
    }

    public void addNewOutputFields(List<Row> output) {
        for (Row row : output) {
            for (Pair field : row.getFields()) {
                String fieldName = (String)field.getFirst();
                Object fieldValue = field.getSecond();
                if (this.outputFieldMap.containsKey(fieldName)) {
                    if (fieldValue == null || this.outputFieldMap.get(fieldName) != null) continue;
                    this.outputFieldMap.put(fieldName, fieldValue);
                    continue;
                }
                this.outputFieldMap.put(fieldName, fieldValue);
            }
        }
    }

    public Schema getDirectiveOutputSchema(SchemaResolutionContext context) throws RecordConvertorException {
        Schema directiveOutputSchema = this.directive.getOutputSchema(context);
        return directiveOutputSchema != null ? directiveOutputSchema : this.generateDirectiveOutputSchema(context.getInputSchema());
    }

    private Schema generateDirectiveOutputSchema(Schema inputSchema) throws RecordConvertorException {
        ArrayList<Schema.Field> outputFields = new ArrayList<Schema.Field>();
        for (Map.Entry<String, Object> field : this.outputFieldMap.entrySet()) {
            Schema generated;
            String fieldName = field.getKey();
            Object fieldValue = field.getValue();
            Schema existing = inputSchema.getField(fieldName) != null ? inputSchema.getField(fieldName).getSchema() : null;
            Schema schema = generated = fieldValue != null && !this.isValidSchemaForValue(existing, fieldValue) ? this.schemaGenerator.getSchema(fieldValue, fieldName) : null;
            if (generated != null) {
                outputFields.add(Schema.Field.of((String)fieldName, generated));
                continue;
            }
            if (existing != null) {
                if (!existing.getType().equals((Object)Schema.Type.NULL) && !existing.isNullable()) {
                    existing = Schema.nullableOf((Schema)existing);
                }
                outputFields.add(Schema.Field.of((String)fieldName, (Schema)existing));
                continue;
            }
            outputFields.add(Schema.Field.of((String)fieldName, (Schema)Schema.of((Schema.Type)Schema.Type.NULL)));
        }
        return Schema.recordOf((String)"output", outputFields);
    }

    private boolean isValidSchemaForValue(@Nullable Schema schema, Object value) throws RecordConvertorException {
        if (schema == null) {
            return false;
        }
        Schema generated = this.schemaGenerator.getSchema(value, "temp_field_name");
        generated = generated.isNullable() ? generated.getNonNullable() : generated;
        schema = schema.isNullable() ? schema.getNonNullable() : schema;
        return generated.getLogicalType() == schema.getLogicalType() && generated.getType() == schema.getType();
    }
}

