/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import io.cdap.cdap.api.artifact.ArtifactId;
import io.cdap.cdap.api.artifact.ArtifactInfo;
import io.cdap.cdap.api.artifact.ArtifactManager;
import io.cdap.cdap.api.artifact.ArtifactSummary;
import io.cdap.cdap.api.artifact.ArtifactVersion;
import io.cdap.cdap.api.artifact.CloseableClassLoader;
import io.cdap.cdap.api.plugin.PluginClass;
import io.cdap.cdap.api.plugin.PluginConfigurer;
import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.api.service.http.HttpServiceContext;
import io.cdap.cdap.api.service.worker.SystemAppTaskContext;
import io.cdap.cdap.etl.api.StageContext;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import io.cdap.wrangler.utils.ArtifactSummaryComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;

public final class UserDirectiveRegistry
implements DirectiveRegistry {
    private static final String WRANGLER_TRANSFORM = "wrangler-transform";
    private static final String WRANGLER_PLUGIN = "Wrangler";
    private final Map<String, Map<String, DirectiveInfo>> registry = new ConcurrentSkipListMap<String, Map<String, DirectiveInfo>>();
    private final List<CloseableClassLoader> classLoaders = new ArrayList<CloseableClassLoader>();
    private StageContext context;
    private HttpServiceContext manager;
    private ArtifactSummary wranglerArtifact;
    private SystemAppTaskContext systemAppTaskContext;

    public UserDirectiveRegistry(HttpServiceContext manager) {
        this.manager = manager;
    }

    public UserDirectiveRegistry(SystemAppTaskContext systemAppTaskContext) {
        this.systemAppTaskContext = systemAppTaskContext;
    }

    public UserDirectiveRegistry(StageContext context) {
        this.context = context;
    }

    @Override
    public DirectiveInfo get(String namespace, String name) throws DirectiveLoadException {
        DirectiveInfo directiveInfo = (DirectiveInfo)this.registry.getOrDefault(namespace, Collections.emptyMap()).get(name);
        if (directiveInfo != null) {
            return directiveInfo;
        }
        try {
            Class<? extends Directive> directive = this.getDirective(namespace, name);
            if (directive == null) {
                throw new DirectiveLoadException(String.format("10-5 - Unable to load the user defined directive '%s'. Please check if the artifact containing UDD is still present.", name));
            }
            return DirectiveInfo.fromUser(directive, null);
        }
        catch (IllegalArgumentException e) {
            throw new DirectiveLoadException(String.format("Directive '%s' not found. Check if the directive is spelled correctly or artifact containing the directive has been uploaded or you might be missing '#pragma load-directives %s;'", name, name), (Exception)e);
        }
        catch (Exception e) {
            throw new DirectiveLoadException(e.getMessage(), e);
        }
    }

    @Nullable
    private Class<? extends Directive> getDirective(String namespace, String name) throws IOException {
        if (this.context != null) {
            return this.context.loadPluginClass(name);
        }
        PluginConfigurer configurer = this.manager != null ? this.manager.createPluginConfigurer(namespace) : this.systemAppTaskContext.createPluginConfigurer(namespace);
        return configurer.usePluginClass("directive", name, UUID.randomUUID().toString(), PluginProperties.builder().build());
    }

    @Override
    public void reload(String namespace) throws DirectiveLoadException {
        TreeMap<String, DirectiveInfo> newRegistry = new TreeMap<String, DirectiveInfo>();
        Map currentRegistry = this.registry.computeIfAbsent(namespace, k -> new ConcurrentSkipListMap());
        ArtifactManager artifactManager = this.getArtifactManager();
        if (artifactManager != null) {
            try {
                List artifacts = artifactManager.listArtifacts(namespace);
                ArtifactSummary latestWrangler = null;
                for (ArtifactInfo artifact : artifacts) {
                    boolean isWranglerArtifact = artifact.getName().equalsIgnoreCase(WRANGLER_TRANSFORM);
                    Set plugins = artifact.getClasses().getPlugins();
                    CloseableClassLoader artifactClassLoader = null;
                    for (PluginClass plugin : plugins) {
                        if ("directive".equalsIgnoreCase(plugin.getType())) {
                            Class cls;
                            if (artifactClassLoader == null) {
                                artifactClassLoader = artifactManager.createClassLoader(namespace, artifact, this.getClass().getClassLoader());
                                this.classLoaders.add(artifactClassLoader);
                            }
                            if (!Directive.class.isAssignableFrom(cls = artifactClassLoader.loadClass(plugin.getClassName()))) {
                                throw new DirectiveLoadException("Plugin class " + plugin.getClassName() + " does not implement the " + Directive.class.getName() + " interface");
                            }
                            DirectiveInfo info = DirectiveInfo.fromUser(cls, new ArtifactId(artifact.getName(), new ArtifactVersion(artifact.getVersion()), artifact.getScope()));
                            newRegistry.put(info.name(), info);
                        }
                        if (!isWranglerArtifact || !WRANGLER_PLUGIN.equals(plugin.getName()) || !"transform".equals(plugin.getType())) continue;
                        latestWrangler = Optional.ofNullable(latestWrangler).map(l -> ArtifactSummaryComparator.pickLatest(l, (ArtifactSummary)artifact)).orElse((ArtifactSummary)artifact);
                    }
                }
                if (latestWrangler != null) {
                    this.wranglerArtifact = latestWrangler;
                }
                MapDifference difference = Maps.difference((Map)currentRegistry, newRegistry);
                for (String directive : difference.entriesOnlyOnLeft().keySet()) {
                    currentRegistry.remove(directive);
                }
                for (String directive : difference.entriesInCommon().keySet()) {
                    currentRegistry.put(directive, difference.entriesInCommon().get(directive));
                }
                for (String directive : difference.entriesOnlyOnRight().keySet()) {
                    currentRegistry.put(directive, difference.entriesOnlyOnRight().get(directive));
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new DirectiveLoadException(e.getMessage(), e);
            }
        }
    }

    @Nullable
    private ArtifactManager getArtifactManager() {
        return this.manager != null ? this.manager : (this.systemAppTaskContext != null ? this.systemAppTaskContext.getArtifactManager() : null);
    }

    @Override
    @Nullable
    public ArtifactSummary getLatestWranglerArtifact() {
        return this.wranglerArtifact;
    }

    @Override
    public Iterable<DirectiveInfo> list(String namespace) {
        Map namespaceDirectives = this.registry.getOrDefault(namespace, Collections.emptyMap());
        return namespaceDirectives.values();
    }

    @Override
    public void close() throws IOException {
        for (CloseableClassLoader classLoader : this.classLoaders) {
            classLoader.close();
        }
    }
}

