/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.artifact.ArtifactSummary;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class SystemDirectiveRegistry
implements DirectiveRegistry {
    public static final SystemDirectiveRegistry INSTANCE;
    private static final String PACKAGE = "io.cdap.directives";
    private final Map<String, DirectiveInfo> registry;

    @VisibleForTesting
    SystemDirectiveRegistry() throws DirectiveLoadException {
        this(new ArrayList<String>());
    }

    public SystemDirectiveRegistry(List<String> namespaces) throws DirectiveLoadException {
        HashMap<String, DirectiveInfo> registry = new HashMap<String, DirectiveInfo>();
        namespaces.add(PACKAGE);
        for (String namespace : namespaces) {
            try {
                Reflections reflections = new Reflections(namespace, new Scanner[0]);
                Set system = reflections.getSubTypesOf(Directive.class);
                for (Class directive : system) {
                    DirectiveInfo info = DirectiveInfo.fromSystem(directive);
                    registry.put(info.name(), info);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DirectiveLoadException(e.getMessage(), (Exception)e);
            }
        }
        this.registry = Collections.unmodifiableMap(registry);
    }

    @Override
    public DirectiveInfo get(String namespace, String name) {
        return this.get(name);
    }

    public DirectiveInfo get(String name) {
        return this.registry.get(name);
    }

    @Override
    public void reload(String namespace) {
    }

    @Override
    @Nullable
    public ArtifactSummary getLatestWranglerArtifact() {
        return null;
    }

    @Override
    public Iterable<DirectiveInfo> list(String namespace) {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    @Override
    public void close() {
    }

    static {
        try {
            INSTANCE = new SystemDirectiveRegistry();
        }
        catch (DirectiveLoadException e) {
            throw new RuntimeException("Failed to load system directives", e);
        }
    }
}

