/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.artifact.ArtifactId;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.parser.DirectiveClass;
import io.cdap.wrangler.registry.DirectiveScope;
import javax.annotation.Nullable;

public final class DirectiveInfo {
    private final DirectiveClass directiveClass;
    private final String description;
    private final boolean deprecated;
    private final String[] categories;
    private final Class<? extends Directive> directive;
    private volatile boolean definitionLoaded;
    private UsageDefinition definition;
    private volatile String usage;

    public static DirectiveInfo fromSystem(Class<? extends Directive> cls) throws InstantiationException, IllegalAccessException {
        return new DirectiveInfo(DirectiveScope.SYSTEM, cls, null);
    }

    public static DirectiveInfo fromUser(Class<? extends Directive> cls, @Nullable ArtifactId artifactId) throws InstantiationException, IllegalAccessException {
        return new DirectiveInfo(DirectiveScope.USER, cls, artifactId);
    }

    private DirectiveInfo(DirectiveScope scope, Class<? extends Directive> directive, @Nullable ArtifactId artifactId) {
        this.directive = directive;
        this.directiveClass = new DirectiveClass(directive.getAnnotation(Name.class).value(), directive.getName(), scope, artifactId);
        Description desc = directive.getAnnotation(Description.class);
        this.description = desc == null ? "No description specified for directive class '" + directive.getSimpleName() + "'" : desc.value();
        this.deprecated = directive.isAnnotationPresent(Deprecated.class);
        Categories category = directive.getAnnotation(Categories.class);
        this.categories = category == null ? new String[]{"default"} : category.categories();
    }

    public DirectiveClass getDirectiveClass() {
        return this.directiveClass;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public DirectiveScope scope() {
        return this.directiveClass.getScope();
    }

    public String name() {
        return this.directiveClass.getName();
    }

    public String usage() {
        if (this.usage != null) {
            return this.usage;
        }
        UsageDefinition definition = this.definition();
        this.usage = definition != null ? definition.toString() : "No definition available for directive '" + this.directive + "'";
        return this.usage;
    }

    public String description() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageDefinition definition() {
        if (this.definitionLoaded) {
            return this.definition;
        }
        DirectiveInfo directiveInfo = this;
        synchronized (directiveInfo) {
            if (this.definitionLoaded) {
                return this.definition;
            }
            try {
                this.definition = this.instance().define();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
            this.definitionLoaded = true;
        }
        return this.definition;
    }

    public String[] categories() {
        return this.categories;
    }

    public Directive instance() throws IllegalAccessException, InstantiationException {
        return this.directive.newInstance();
    }
}

