/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import com.google.common.collect.Iterables;
import io.cdap.cdap.api.artifact.ArtifactSummary;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import io.cdap.wrangler.utils.ArtifactSummaryComparator;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;

public final class CompositeDirectiveRegistry
implements DirectiveRegistry {
    private final DirectiveRegistry[] registries;

    public CompositeDirectiveRegistry(DirectiveRegistry ... registries) {
        this.registries = registries;
    }

    @Override
    @Nullable
    public DirectiveInfo get(String namespace, String directive) throws DirectiveLoadException {
        for (DirectiveRegistry registry : this.registries) {
            DirectiveInfo info = registry.get(namespace, directive);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    public void reload(String namespace) throws DirectiveLoadException {
        for (DirectiveRegistry registry : this.registries) {
            registry.reload(namespace);
        }
    }

    @Override
    @Nullable
    public ArtifactSummary getLatestWranglerArtifact() {
        ArtifactSummary latestArtifact = null;
        for (DirectiveRegistry registry : this.registries) {
            ArtifactSummary artifact = registry.getLatestWranglerArtifact();
            if (artifact == null) continue;
            latestArtifact = latestArtifact == null ? artifact : ArtifactSummaryComparator.pickLatest(latestArtifact, artifact);
        }
        return latestArtifact;
    }

    @Override
    public Iterable<DirectiveInfo> list(String namespace) {
        ArrayList<Iterable<DirectiveInfo>> lists = new ArrayList<Iterable<DirectiveInfo>>();
        for (DirectiveRegistry registry : this.registries) {
            lists.add(registry.list(namespace));
        }
        return Iterables.concat(lists);
    }

    @Override
    public void close() throws IOException {
        for (DirectiveRegistry registry : this.registries) {
            registry.close();
        }
    }
}

