/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import io.cdap.wrangler.api.CompileException;
import io.cdap.wrangler.api.CompileStatus;
import io.cdap.wrangler.api.Compiler;
import io.cdap.wrangler.api.DirectiveContext;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.TokenGroup;
import io.cdap.wrangler.api.parser.DirectiveName;
import io.cdap.wrangler.api.parser.SyntaxError;
import java.util.Iterator;

public class GrammarWalker {
    private final Compiler compiler;
    private final DirectiveContext context;

    public GrammarWalker(Compiler compiler, DirectiveContext context) {
        this.compiler = compiler;
        this.context = context;
    }

    public <E extends Exception> void walk(String recipe, Visitor<E> visitor) throws CompileException, DirectiveParseException, E {
        CompileStatus status = this.compiler.compile(recipe);
        if (!status.isSuccess()) {
            Iterator errors = status.getErrors();
            String prefix = "Encountered syntax error, please ensure the directive is valid:\n";
            throw new DirectiveParseException(prefix + ((SyntaxError)errors.next()).getMessage(), errors);
        }
        for (TokenGroup tokenGroup : status.getSymbols()) {
            if (tokenGroup == null) continue;
            String command = ((DirectiveName)tokenGroup.get(0)).value();
            String root = command;
            if (this.context.hasAlias(root)) {
                root = this.context.getAlias(command);
            }
            if (!root.equals(command) && this.context.isExcluded(command)) {
                throw new DirectiveParseException(command, String.format("Aliased directive '%s' has been configured as restricted directive and is hence unavailable. Please contact your administrator", command));
            }
            if (this.context.isExcluded(root)) {
                throw new DirectiveParseException(command, String.format("Directive '%s' has been configured as restricted directive and is hence unavailable. Please contact your administrator", command));
            }
            visitor.visit(root, tokenGroup);
        }
    }

    public static interface Visitor<E extends Exception> {
        public void visit(String var1, TokenGroup var2) throws E;
    }
}

