/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import com.google.common.base.Joiner;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveContext;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.api.DirectiveNotFoundException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.RecipeException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.parser.GrammarWalker;
import io.cdap.wrangler.parser.MapArguments;
import io.cdap.wrangler.parser.NoOpDirectiveContext;
import io.cdap.wrangler.parser.RecipeCompiler;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class GrammarBasedParser
implements RecipeParser {
    private static final char EOL = '\n';
    private final String namespace;
    private final DirectiveRegistry registry;
    private final String recipe;
    private final DirectiveContext context;

    public GrammarBasedParser(String namespace, String recipe, DirectiveRegistry registry) {
        this(namespace, recipe, registry, (DirectiveContext)new NoOpDirectiveContext());
    }

    public GrammarBasedParser(String namespace, String[] directives, DirectiveRegistry registry, DirectiveContext context) {
        this(namespace, Joiner.on((char)'\n').join((Object[])directives), registry, context);
    }

    public GrammarBasedParser(String namespace, String recipe, DirectiveRegistry registry, DirectiveContext context) {
        this.namespace = namespace;
        this.recipe = recipe;
        this.registry = registry;
        this.context = context;
    }

    public List<Directive> parse() throws RecipeException {
        AtomicInteger directiveIndex = new AtomicInteger();
        try {
            ArrayList<Directive> result = new ArrayList<Directive>();
            new GrammarWalker(new RecipeCompiler(), this.context).walk(this.recipe, (command, tokenGroup) -> {
                directiveIndex.getAndIncrement();
                DirectiveInfo info = this.registry.get(this.namespace, command);
                if (info == null) {
                    throw new DirectiveNotFoundException(String.format("Directive '%s' not found in system and user scope. Check the name of directive.", command));
                }
                try {
                    Directive directive = info.instance();
                    UsageDefinition definition = directive.define();
                    MapArguments arguments = new MapArguments(definition, tokenGroup);
                    directive.initialize((Arguments)arguments);
                    result.add(directive);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new DirectiveLoadException(e.getMessage(), (Exception)e);
                }
            });
            return result;
        }
        catch (DirectiveLoadException | DirectiveNotFoundException | DirectiveParseException e) {
            throw new RecipeException(e.getMessage(), e, directiveIndex.get());
        }
        catch (Exception e) {
            throw new RecipeException(e.getMessage(), (Throwable)e);
        }
    }
}

