/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.metrics;

import io.cdap.wrangler.api.EntityCountMetric;
import io.cdap.wrangler.expression.EL;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.jexl3.parser.ParserTokenManager;
import org.apache.commons.jexl3.parser.SimpleCharStream;

public final class JexlCategoryMetricUtils {
    private static final Map<?, ?> EL_DEFAULT_FUNCTIONS = new EL.DefaultFunctions().functions();
    public static final String JEXL_CATEGORY_METRIC_NAME = "wrangler.jexl-category.count";
    public static final int JEXL_CATEGORY_METRIC_COUNT = 1;
    public static final String JEXL_CATEGORY_ENTITY_TYPE = "jexl-category";

    @Nullable
    public static EntityCountMetric getJexlCategoryMetric(String jexlScript) {
        String category = JexlCategoryMetricUtils.parseJexlCategory(jexlScript);
        if (EL_DEFAULT_FUNCTIONS.containsKey(category)) {
            return new EntityCountMetric(JEXL_CATEGORY_METRIC_NAME, JEXL_CATEGORY_ENTITY_TYPE, category, 1L);
        }
        return null;
    }

    private static String parseJexlCategory(String script) {
        ParserTokenManager manager = new ParserTokenManager(new SimpleCharStream((InputStream)new ByteArrayInputStream(script.getBytes())));
        return manager.getNextToken().toString();
    }
}

