/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.expression;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.functions.DDL;
import io.cdap.functions.DataQuality;
import io.cdap.functions.DateAndTime;
import io.cdap.functions.Dates;
import io.cdap.functions.GeoFences;
import io.cdap.functions.Global;
import io.cdap.functions.JsonFunctions;
import io.cdap.functions.Logical;
import io.cdap.functions.NumberFunctions;
import io.cdap.wrangler.expression.ELContext;
import io.cdap.wrangler.expression.ELException;
import io.cdap.wrangler.expression.ELRegistration;
import io.cdap.wrangler.expression.ELResult;
import io.cdap.wrangler.utils.ArithmeticOperations;
import io.cdap.wrangler.utils.DecimalTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;

public final class EL {
    private static volatile boolean used;
    private final Set<String> variables;
    private final JexlScript script;

    public static boolean isUsed() {
        return used;
    }

    public static EL compile(String expression) throws ELException {
        return EL.compile(new DefaultFunctions(), expression);
    }

    public static EL compile(ELRegistration registration, String expression) throws ELException {
        used = true;
        JexlEngine engine = new JexlBuilder().namespaces(registration.functions()).silent(false).cache(1024).strict(true).logger((Log)new NullLogger()).create();
        try {
            HashSet<String> variables = new HashSet<String>();
            JexlScript script = engine.createScript(expression);
            Set varSet = script.getVariables();
            for (List vars : varSet) {
                variables.add(Joiner.on((String)".").join((Iterable)vars));
            }
            return new EL(script, variables);
        }
        catch (JexlException e) {
            JexlInfo info = e.getInfo();
            throw new ELException(String.format("Error encountered while compiling '%s' at line '%d' and column '%d'. Make sure a valid jexl transformation is provided.", info.getDetail() == null ? expression : info.getDetail(), info.getLine(), info.getColumn()), e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    private EL(JexlScript script, Set<String> variables) {
        this.script = script;
        this.variables = Collections.unmodifiableSet(variables);
    }

    public Set<String> variables() {
        return this.variables;
    }

    public String getScriptParsedText() {
        return this.script.getParsedText();
    }

    public ELResult execute(ELContext context) throws ELException {
        try {
            for (String variable : this.variables) {
                if (context.has(variable)) continue;
                context.add(variable, null);
            }
            Object value = this.script.execute((JexlContext)context);
            return new ELResult(value);
        }
        catch (JexlException e) {
            JexlInfo info = e.getInfo();
            throw new ELException(String.format("Error encountered while executing '%s', at line '%d' and column '%d'. Make sure a valid jexl transformation is provided.", info.getDetail() == null ? this.script.getSourceText() : info.getDetail(), info.getLine(), info.getColumn()), e);
        }
        catch (NumberFormatException e) {
            throw new ELException("Type mismatch. Change type of constant or convert to right data type using conversion functions available. Reason : " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new ELException(e.getCause().getMessage(), e);
            }
            throw new ELException(e);
        }
    }

    private static final class NullLogger
    implements Log {
        private NullLogger() {
        }

        public void debug(Object o) {
        }

        public void debug(Object o, Throwable throwable) {
        }

        public void error(Object o) {
        }

        public void error(Object o, Throwable throwable) {
        }

        public void fatal(Object o) {
        }

        public void fatal(Object o, Throwable throwable) {
        }

        public void info(Object o) {
        }

        public void info(Object o, Throwable throwable) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isFatalEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void trace(Object o) {
        }

        public void trace(Object o, Throwable throwable) {
        }

        public void warn(Object o) {
        }

        public void warn(Object o, Throwable throwable) {
        }
    }

    public static final class DefaultFunctions
    implements ELRegistration {
        @Override
        public Map<String, Object> functions() {
            HashMap<String, Object> functions = new HashMap<String, Object>();
            functions.put(null, Global.class);
            functions.put("datetime", DateAndTime.class);
            functions.put("date", Dates.class);
            functions.put("json", JsonFunctions.class);
            functions.put("math", Math.class);
            functions.put("decimal", DecimalTransform.class);
            functions.put("arithmetic", ArithmeticOperations.class);
            functions.put("string", StringUtils.class);
            functions.put("strings", Strings.class);
            functions.put("escape", StringEscapeUtils.class);
            functions.put("bytes", Bytes.class);
            functions.put("arrays", Arrays.class);
            functions.put("dq", DataQuality.class);
            functions.put("ddl", DDL.class);
            functions.put("geo", GeoFences.class);
            functions.put("number", NumberFunctions.class);
            functions.put("logical", Logical.class);
            return functions;
        }
    }
}

