/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dq;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DateTimePattern {
    private static final List<Map<Pattern, String>> DATE_PATTERN_GROUP_LIST = new ArrayList<Map<Pattern, String>>();
    private static final List<Map<Pattern, String>> TIME_PATTERN_GROUP_LIST = new ArrayList<Map<Pattern, String>>();

    private static void loadPatterns(String patternFileName, List<Map<Pattern, String>> patternParsers) {
        InputStream stream = DateTimePattern.class.getClassLoader().getResourceAsStream(patternFileName);
        try {
            List lines = IOUtils.readLines((InputStream)stream, (String)"UTF-8");
            LinkedHashMap<Pattern, String> currentGroupMap = new LinkedHashMap<Pattern, String>();
            patternParsers.add(currentGroupMap);
            for (String line : lines) {
                if ("".equals(line.trim())) continue;
                if (line.startsWith("--")) {
                    currentGroupMap = new LinkedHashMap();
                    patternParsers.add(currentGroupMap);
                    continue;
                }
                String[] lineArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)line, (String)"\t");
                String format = lineArray[0];
                Pattern pattern = Pattern.compile(lineArray[1]);
                currentGroupMap.put(pattern, format);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isDate(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (value.length() < 6 || value.length() > 64) {
            return false;
        }
        return DateTimePattern.isDateTime(DATE_PATTERN_GROUP_LIST, value);
    }

    public static boolean isTime(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (value.length() < 4 || value.length() > 24) {
            return false;
        }
        return DateTimePattern.isDateTime(TIME_PATTERN_GROUP_LIST, value);
    }

    private static boolean isDateTime(List<Map<Pattern, String>> patternGroupList, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            boolean hasEnoughDigits = false;
            int digitCount = 0;
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch < '0' || ch > '9' || ++digitCount <= 2) continue;
                hasEnoughDigits = true;
                break;
            }
            if (!hasEnoughDigits) {
                return false;
            }
            for (Map<Pattern, String> patternMap : patternGroupList) {
                for (Pattern parser : patternMap.keySet()) {
                    try {
                        if (!parser.matcher(value).find()) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        return false;
    }

    public static Set<String> datePatternReplace(String value) {
        return DateTimePattern.dateTimePatternReplace(DATE_PATTERN_GROUP_LIST, value);
    }

    public static Set<String> timePatternReplace(String value) {
        return DateTimePattern.dateTimePatternReplace(TIME_PATTERN_GROUP_LIST, value);
    }

    private static Set<String> dateTimePatternReplace(List<Map<Pattern, String>> patternGroupList, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.singleton("");
        }
        HashSet<String> resultSet = new HashSet<String>();
        for (Map<Pattern, String> patternMap : patternGroupList) {
            for (Pattern parser : patternMap.keySet()) {
                if (!parser.matcher(value).find()) continue;
                resultSet.add(patternMap.get(parser));
            }
            if (resultSet.isEmpty()) continue;
            return resultSet;
        }
        return resultSet;
    }

    static {
        DateTimePattern.loadPatterns("DateRegexesGrouped.txt", DATE_PATTERN_GROUP_LIST);
        DateTimePattern.loadPatterns("TimeRegexes.txt", TIME_PATTERN_GROUP_LIST);
    }
}

