/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;

public final class DateAndTime {
    private static final DateTimeFormatter DATE_TIME_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, false).toFormatter()).toFormatter();
    private static final DateTimeFormatter TIME_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, false).toFormatter()).toFormatter();
    private static final DateTimeFormatter OUTPUT_DATETIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss dd MMM yyyy");

    private static DayOfWeek getDayOfWeek(String textDay) {
        DayOfWeek dayOfWeek = DayOfWeek.SUNDAY;
        switch (textDay.toUpperCase()) {
            case "MON": 
            case "MONDAY": {
                dayOfWeek = DayOfWeek.MONDAY;
                break;
            }
            case "TUE": 
            case "TUESDAY": {
                dayOfWeek = DayOfWeek.TUESDAY;
                break;
            }
            case "WED": 
            case "WEDNESDAY": {
                dayOfWeek = DayOfWeek.WEDNESDAY;
                break;
            }
            case "THU": 
            case "THURSDAY": {
                dayOfWeek = DayOfWeek.THURSDAY;
                break;
            }
            case "FRI": 
            case "FRIDAY": {
                dayOfWeek = DayOfWeek.FRIDAY;
                break;
            }
            case "SAT": 
            case "SATUDAY": {
                dayOfWeek = DayOfWeek.SATURDAY;
                break;
            }
            case "SUN": 
            case "SUNDAY": {
                dayOfWeek = DayOfWeek.SUNDAY;
            }
        }
        return dayOfWeek;
    }

    public static LocalDate GetDate(String date) {
        return date == null ? null : LocalDate.parse(date, DATE_TIME_FORMAT);
    }

    public static LocalTime GetTime(String time) {
        return time == null ? null : LocalTime.parse(time, TIME_FORMAT);
    }

    public static LocalDateTime GetDateTime(String date) {
        return LocalDateTime.parse(date, DATE_TIME_FORMAT);
    }

    public static LocalDate CurrentDate() {
        return LocalDate.now();
    }

    public static LocalTime CurrentTime() {
        return LocalTime.now();
    }

    public static long CurrentTimeMS() {
        return (long)DateAndTime.CurrentTime().getNano() / 1000000L;
    }

    public static LocalDateTime CurrentDateTime() {
        return LocalDateTime.now();
    }

    public static ZonedDateTime CurrentTimestamp() {
        return ZonedDateTime.now();
    }

    public static long EpochSeconds() {
        return Instant.now().getEpochSecond();
    }

    public static long CurrentTimestampMS() {
        return Instant.now().toEpochMilli();
    }

    public static long CurrentTimestampNano() {
        return Instant.now().getNano();
    }

    public static LocalDate DateFromDaysSince(Integer days) {
        return DateAndTime.DateFromDaysSince(days, LocalDate.now());
    }

    public static LocalDate DateFromDaysSince(Integer days, LocalDate baseline) {
        baseline = baseline == null ? LocalDate.now() : baseline;
        return baseline.plusDays(days == null ? 0L : (long)days.intValue());
    }

    public static LocalDate DateFromComponents(Integer year, Integer month, Integer day) {
        return year == null || month == null || day == null ? null : LocalDate.of((int)year, month, (int)day);
    }

    public static LocalDate DateFromJulianDay(Long julianDay) {
        DateTime datetime = new DateTime(DateTimeUtils.fromJulianDay((double)(julianDay == null ? 0.0 : julianDay.doubleValue())));
        return LocalDate.of(datetime.getYear(), datetime.getMonthOfYear(), datetime.getDayOfMonth());
    }

    public static LocalDate DateOffsetByComponents(LocalDate baseline, Integer yearOffset, Integer monthOffset, Integer daysOffset) {
        return baseline == null ? null : baseline.plusYears(yearOffset == null ? 0L : yearOffset.longValue()).plusMonths(monthOffset == null ? 0L : monthOffset.longValue()).plusDays(daysOffset == null ? 0L : daysOffset.longValue());
    }

    public static Long DaysSinceFromDate(LocalDate source, LocalDate destination) {
        return source == null || destination == null ? null : Long.valueOf(ChronoUnit.DAYS.between(source, destination));
    }

    public static Integer DaysInMonth(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.getMonth().maxLength());
    }

    public static Integer DaysInYear(LocalDate date) {
        return date == null ? null : Integer.valueOf(Year.of(date.getYear()).length());
    }

    public static LocalDate DateOffsetByDays(LocalDate date, Integer daysOffset) {
        return date == null ? null : date.plusDays(daysOffset == null ? 0L : (long)daysOffset.intValue());
    }

    public static Integer HoursFromTime(LocalTime time) {
        return time == null ? null : Integer.valueOf(time.getHour());
    }

    public static Long JulianDayFromDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        long l = date.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        return DateTimeUtils.toJulianDayNumber((long)l);
    }

    public static Integer NanoSecondsFromTime(LocalTime time) {
        return time == null ? null : Integer.valueOf(time.getNano());
    }

    public static Integer MicroSecondsFromTime(LocalTime time) {
        return DateAndTime.NanoSecondsFromTime(time) / 1000;
    }

    public static Integer MilliSecondsFromTime(LocalTime time) {
        return DateAndTime.MicroSecondsFromTime(time) / 1000;
    }

    public static Integer MidnightSecondsFromTime(LocalTime time) {
        return time == null ? null : Integer.valueOf(time.toSecondOfDay());
    }

    public static Integer MinutesFromTime(LocalTime time) {
        return time == null ? null : Integer.valueOf(time.getMinute());
    }

    public static Integer MonthDayFromDate(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.getDayOfMonth());
    }

    public static Integer MonthFromDate(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.getMonthValue());
    }

    public static LocalDate NextWeekdayFromDate(LocalDate source, String textDayOfWeek) {
        return source == null ? null : (textDayOfWeek == null ? source : source.with(TemporalAdjusters.next(DateAndTime.getDayOfWeek(textDayOfWeek))));
    }

    public static LocalDate NthWeekdayFromDate(LocalDate source, String textDayOfWeek, Number offset) {
        if (source == null || textDayOfWeek == null) {
            return source;
        }
        LocalDate target = source;
        int counter = offset == null ? 0 : Math.abs(offset.intValue());
        for (int i = 0; i < counter; ++i) {
            target = target.with(offset.intValue() > 0 ? TemporalAdjusters.next(DateAndTime.getDayOfWeek(textDayOfWeek)) : TemporalAdjusters.previous(DateAndTime.getDayOfWeek(textDayOfWeek)));
        }
        return target;
    }

    public static LocalDate PreviousWeekdayFromDate(LocalDate source, String textDayOfWeek) {
        return source == null ? null : (textDayOfWeek == null ? source : source.with(TemporalAdjusters.previous(DateAndTime.getDayOfWeek(textDayOfWeek))));
    }

    public static Integer SecondsFromTime(LocalTime time) {
        return time == null ? null : Integer.valueOf(time.getSecond());
    }

    public static Long SecondsSinceFromDateTime(LocalDateTime source, LocalDateTime destination) {
        return source == null || destination == null ? null : Long.valueOf(Duration.between(destination, source).getSeconds());
    }

    public static String TimeDate() {
        return LocalDateTime.now().format(OUTPUT_DATETIME_FORMAT);
    }

    public static LocalTime TimeFromComponents(Integer hours, Integer mins, Integer seconds, Integer microseconds) {
        return hours == null || mins == null || seconds == null || microseconds == null ? null : LocalTime.of(hours, mins, seconds, microseconds * 1000);
    }

    public static LocalTime TimeFromMidnightSeconds(Integer seconds) {
        return LocalTime.of(0, 0, 0).plusSeconds(seconds == null ? 0L : (long)seconds.intValue());
    }

    public static LocalTime TimeOffsetByComponents(LocalTime time, Integer hour, Integer min, Integer seconds) {
        return time == null ? null : time.plusHours(hour == null ? 0L : (long)hour.intValue()).plusMinutes(min == null ? 0L : (long)min.intValue()).plusSeconds(seconds == null ? 0L : (long)seconds.intValue());
    }

    public static LocalDateTime GetDateTime(LocalDate date, LocalTime time) {
        return date == null || time == null ? null : LocalDateTime.of(date, time);
    }

    public static LocalDateTime DateTimeFromSecondsSince(Integer seconds, LocalDateTime time) {
        return time == null ? null : time.plusSeconds(seconds == null ? 0L : (long)seconds.intValue());
    }

    public static LocalDateTime DateTimeFromEpoch(Long epochTimestamp) {
        return epochTimestamp == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTimestamp * 1000L), ZoneId.of("UTC"));
    }

    public static LocalDateTime DateTimeFromTime(LocalTime time, LocalDateTime datetime) {
        return datetime == null ? null : (time == null ? datetime : datetime.withHour(time.getHour()).withMinute(time.getMinute()).withSecond(time.getSecond()).withNano(time.getNano()));
    }

    public static LocalDateTime DateTimeOffsetByComponents(LocalDateTime datetime, Integer yearOffset, Integer monthOffset, Integer dayOfMonthOffset, Integer hourOffset, Integer minOffset, Integer secondOffset) {
        return datetime == null ? null : datetime.plusYears(yearOffset == null ? 0L : (long)yearOffset.intValue()).plusMonths(monthOffset == null ? 0L : (long)monthOffset.intValue()).plusDays(dayOfMonthOffset == null ? 0L : (long)dayOfMonthOffset.intValue()).plusHours(hourOffset == null ? 0L : (long)hourOffset.intValue()).plusMinutes(minOffset == null ? 0L : (long)minOffset.intValue()).plusSeconds(secondOffset == null ? 0L : (long)secondOffset.intValue());
    }

    public static LocalDateTime DateTimeOffsetBySeconds(LocalDateTime datetime, Integer secondsOffset) {
        return datetime == null ? null : datetime.plusSeconds(secondsOffset == null ? 0L : (long)secondsOffset.intValue());
    }

    public static Long EpochFromDateTime(LocalDateTime datetime) {
        return datetime == null ? null : Long.valueOf(datetime.toEpochSecond(ZoneOffset.UTC));
    }

    public static Long EpochFromTimestamp(ZonedDateTime timestamp) {
        return timestamp == null ? null : Long.valueOf(timestamp.toEpochSecond());
    }

    public static Integer WeekdayFromDate(LocalDate date, String startOfWeek) {
        if (date == null) {
            return null;
        }
        int daysInWeek = startOfWeek == null ? date.getDayOfWeek().getValue() : date.with(TemporalAdjusters.previousOrSame(DayOfWeek.valueOf(startOfWeek.toUpperCase()))).getDayOfWeek().getValue();
        return 7 - daysInWeek + 1;
    }

    public static Integer WeekdayFromDate(LocalDate date) {
        return DateAndTime.WeekdayFromDate(date, "Sunday");
    }

    public static Integer YeardayFromDate(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.getDayOfYear());
    }

    public static Integer YearFromDate(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.getYear());
    }

    public static Integer YearweekFromDate(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.get(WeekFields.of(DayOfWeek.MONDAY, 7).weekOfWeekBasedYear()));
    }
}

