/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import io.cdap.functions.Types;
import io.cdap.wrangler.api.Row;
import org.apache.commons.validator.routines.CreditCardValidator;
import org.apache.commons.validator.routines.DateValidator;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.ISBNValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class DataQuality
extends Types {
    private DataQuality() {
    }

    public static int columns(Row row) {
        return row.width();
    }

    public static boolean hascolumn(Row row, String column) {
        if (column == null) {
            return false;
        }
        return row.find(column) != -1;
    }

    public static boolean inrange(double value, double lower, double upper) {
        Range range = Range.range((Comparable)Double.valueOf(lower), (BoundType)BoundType.CLOSED, (Comparable)Double.valueOf(upper), (BoundType)BoundType.CLOSED);
        return range.contains((Comparable)Double.valueOf(value));
    }

    public static int strlen(String str) {
        if (str != null) {
            return str.length();
        }
        return 0;
    }

    public static boolean isnull(Object object) {
        return object == null;
    }

    public static boolean isempty(String str) {
        return str != null && str.isEmpty();
    }

    public static boolean isDate(String date) {
        return DateValidator.getInstance().isValid(date);
    }

    public static boolean isDate(String date, String pattern) {
        return DateValidator.getInstance().isValid(date, pattern);
    }

    public static boolean isIP(String ip) {
        return InetAddressValidator.getInstance().isValid(ip);
    }

    public static boolean isIPv4(String ip) {
        return InetAddressValidator.getInstance().isValidInet4Address(ip);
    }

    public static boolean isIPv6(String ip) {
        return InetAddressValidator.getInstance().isValidInet6Address(ip);
    }

    public static boolean isEmail(String email) {
        return EmailValidator.getInstance().isValid(email);
    }

    public static boolean isUrl(String url) {
        return UrlValidator.getInstance().isValid(url);
    }

    public static boolean isDomainName(String domain) {
        return DomainValidator.getInstance().isValid(domain);
    }

    public static boolean isDomainTld(String domain) {
        return DomainValidator.getInstance().isValidTld(domain);
    }

    public static boolean isGenericTld(String domain) {
        return DomainValidator.getInstance().isValidGenericTld(domain);
    }

    public static boolean isCountryTld(String domain) {
        return DomainValidator.getInstance().isValidCountryCodeTld(domain);
    }

    public static boolean isISBN(String isbn) {
        return ISBNValidator.getInstance().isValid(isbn);
    }

    public static boolean isISBN10(String isbn) {
        return ISBNValidator.getInstance().isValidISBN10(isbn);
    }

    public static boolean isISBN13(String isbn) {
        return ISBNValidator.getInstance().isValidISBN13(isbn);
    }

    public static boolean isCreditCard(String cc) {
        return CreditCardValidator.genericCreditCardValidator().isValid(cc);
    }

    public static boolean isAmex(String cc) {
        return CreditCardValidator.AMEX_VALIDATOR.isValid(cc);
    }

    public static boolean isVisa(String cc) {
        return CreditCardValidator.VISA_VALIDATOR.isValid(cc);
    }

    public static boolean isMaster(String cc) {
        return CreditCardValidator.MASTERCARD_VALIDATOR.isValid(cc);
    }

    public static boolean isDiner(String cc) {
        return CreditCardValidator.DINERS_VALIDATOR.isValid(cc);
    }

    public static boolean isDiscover(String cc) {
        return CreditCardValidator.DISCOVER_VALIDATOR.isValid(cc);
    }

    public static boolean isVPay(String cc) {
        return CreditCardValidator.VPAY_VALIDATOR.isValid(cc);
    }
}

