/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.validation.conformers;

import com.google.gson.JsonObject;
import io.cdap.directives.validation.ConformanceIssue;
import io.cdap.directives.validation.conformers.Conformer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Validator;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonConformer
implements Conformer<JsonObject> {
    public static final String SCHEMA_FORMAT = "json";
    private final Supplier<InputStream> schemaStream;
    private Schema schema;

    private JsonConformer(Supplier<InputStream> stream) {
        this.schemaStream = stream;
    }

    static List<ConformanceIssue> convertValidationException(ValidationException e) {
        ValidationException[] nonTrivialCauses = (ValidationException[])e.getCausingExceptions().stream().filter(c -> !c.getPointerToViolation().equals("#")).toArray(ValidationException[]::new);
        if (nonTrivialCauses.length > 0) {
            return Arrays.stream(nonTrivialCauses).flatMap(ntc -> JsonConformer.getLeafExceptions(null, ntc)).distinct().collect(Collectors.toList());
        }
        return Collections.singletonList(new ConformanceIssue(e.getSchemaLocation(), e.getPointerToViolation(), e.toJSON().toString()));
    }

    private static Stream<ConformanceIssue> getLeafExceptions(String schemaPath, ValidationException ve) {
        String newSchemaPath = (schemaPath != null && !schemaPath.isEmpty() ? schemaPath + " -> " : "") + ve.getSchemaLocation();
        if (ve.getCausingExceptions().size() == 0) {
            return Stream.of(new ConformanceIssue(newSchemaPath, ve.getPointerToViolation(), ve.getMessage()));
        }
        return ve.getCausingExceptions().stream().flatMap(c -> JsonConformer.getLeafExceptions(newSchemaPath, c));
    }

    @Override
    public void initialize() throws IOException {
        try (InputStream stream = this.schemaStream.get();
             InputStreamReader reader = new InputStreamReader(stream);){
            JSONObject schemaJson = new JSONObject(new JSONTokener((Reader)reader));
            this.schema = SchemaLoader.builder().schemaJson(schemaJson).build().load().build();
        }
    }

    @Override
    public List<ConformanceIssue> checkConformance(JsonObject value) {
        JSONObject orgJsonObject = new JSONObject(new JSONTokener(value.toString()));
        try {
            Validator validator = Validator.builder().failEarly().build();
            validator.performValidation(this.schema, (Object)orgJsonObject);
        }
        catch (ValidationException e) {
            return JsonConformer.convertValidationException(e);
        }
        return Collections.emptyList();
    }

    public static class Factory
    implements Conformer.Factory<JsonObject> {
        private Supplier<InputStream> stream;

        public Factory setSchemaStreamSupplier(Supplier<InputStream> schemaStream) {
            this.stream = schemaStream;
            return this;
        }

        public JsonConformer build() {
            return new JsonConformer(this.stream);
        }
    }
}

