/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.validation;

import java.util.Objects;

public class ConformanceIssue {
    private final String schemaLocation;
    private final String dataLocation;
    private final String error;

    public ConformanceIssue(String schemaLocation, String dataLocation, String error) {
        this.schemaLocation = schemaLocation;
        this.dataLocation = dataLocation;
        this.error = error;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getDataLocation() {
        return this.dataLocation;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        String dataLocation;
        String error = this.getError();
        if (error.contains(dataLocation = this.getDataLocation())) {
            return String.format("error at schema %s: %s", this.getSchemaLocation(), error);
        }
        return String.format("error at schema %s, at data %s: %s", this.getSchemaLocation(), dataLocation, error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConformanceIssue that = (ConformanceIssue)o;
        return Objects.equals(this.schemaLocation, that.schemaLocation) && Objects.equals(this.dataLocation, that.dataLocation) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.schemaLocation, this.dataLocation, this.error);
    }
}

