/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

@Plugin(type="directive")
@Name(value="split-url")
@Categories(categories={"transform", "url"})
@Description(value="Split a url into it's components host,protocol,port,etc.")
public class SplitURL
implements Directive,
Lineage {
    public static final String NAME = "split-url";
    private String column;
    private String protocolCol;
    private String authCol;
    private String hostCol;
    private String portCol;
    private String pathCol;
    private String queryCol;
    private String fileCol;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.protocolCol = this.column + "_protocol";
        this.authCol = this.column + "_authority";
        this.hostCol = this.column + "_host";
        this.portCol = this.column + "_port";
        this.pathCol = this.column + "_path";
        this.queryCol = this.column + "_query";
        this.fileCol = this.column + "_filename";
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                Object object = row.getValue(idx);
                if (object == null) {
                    row.add(this.protocolCol, null);
                    row.add(this.authCol, null);
                    row.add(this.hostCol, null);
                    row.add(this.portCol, null);
                    row.add(this.pathCol, null);
                    row.add(this.queryCol, null);
                    row.add(this.fileCol, null);
                    continue;
                }
                if (object instanceof String) {
                    try {
                        URL url = new URL((String)object);
                        row.add(this.protocolCol, (Object)url.getProtocol());
                        row.add(this.authCol, (Object)url.getAuthority());
                        row.add(this.hostCol, (Object)url.getHost());
                        row.add(this.portCol, (Object)url.getPort());
                        row.add(this.pathCol, (Object)url.getPath());
                        row.add(this.fileCol, (Object)url.getFile());
                        row.add(this.queryCol, (Object)url.getQuery());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new DirectiveExecutionException(NAME, String.format("Malformed url '%s' found in column '%s'.", (String)object, this.column), (Throwable)e);
                    }
                }
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()));
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.column));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Split column '%s' into url parts as columns '%s', '%s', '%s', '%s', '%s', '%s', '%s'", new Object[]{this.column, this.protocolCol, this.authCol, this.hostCol, this.portCol, this.pathCol, this.queryCol, this.fileCol}).relation(this.column, Many.of((String[])new String[]{this.column, this.protocolCol, this.authCol, this.hostCol, this.portCol, this.pathCol, this.queryCol, this.fileCol})).build();
    }
}

