/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.Triplet;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.Ranges;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="quantize")
@Categories(categories={"transform"})
@Description(value="Quanitize the range of numbers into label values.")
public class Quantization
implements Directive,
Lineage {
    public static final String NAME = "quantize";
    private final RangeMap<Double, String> rangeMap = TreeRangeMap.create();
    private String col1;
    private String col2;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define("ranges", TokenType.RANGES);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col1 = ((ColumnName)args.value("source")).value();
        this.col2 = ((ColumnName)args.value("destination")).value();
        List ranges = ((Ranges)args.value("ranges")).value();
        for (Triplet range : ranges) {
            double lower = ((Numeric)range.getFirst()).value().doubleValue();
            double upper = ((Numeric)range.getSecond()).value().doubleValue();
            this.rangeMap.put(Range.closed((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper)), range.getThird());
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            int idx = row.find(this.col1);
            if (idx != -1) {
                try {
                    Double d;
                    Object object = row.getValue(idx);
                    if (object == null) {
                        throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String', 'Float' or 'Double'.", this.col1));
                    }
                    if (object instanceof String) {
                        d = Double.parseDouble((String)object);
                    } else if (object instanceof Double) {
                        d = (Double)object;
                    } else if (object instanceof Float) {
                        d = ((Float)object).doubleValue();
                    } else {
                        throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String', 'Float' or 'Double'.", this.col1, object.getClass().getSimpleName()));
                    }
                    String value = (String)this.rangeMap.get((Comparable)d);
                    int destIdx = row.find(this.col2);
                    if (destIdx == -1) {
                        row.add(this.col2, (Object)value);
                    }
                    row.setValue(destIdx, (Object)value);
                }
                catch (NumberFormatException e) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type. It should be of type 'String', 'Float' or 'Double'.", this.col1), (Throwable)e);
                }
            } else {
                throw new DirectiveExecutionException(NAME, "Column '" + this.col1 + "' does not exist.");
            }
            results.add(row);
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Quanitized column '%s' into column '%s'", new Object[]{this.col1, this.col2}).conditional(this.col1, this.col2).build();
    }
}

