/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import com.google.common.collect.ImmutableList;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.EntityCountMetric;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Expression;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.expression.EL;
import io.cdap.wrangler.expression.ELContext;
import io.cdap.wrangler.expression.ELException;
import io.cdap.wrangler.expression.ELResult;
import io.cdap.wrangler.metrics.JexlCategoryMetricUtils;
import java.util.List;

@Plugin(type="directive")
@Name(value="set-column")
@Categories(categories={"transform"})
@Description(value="Sets a column by evaluating a JEXL expression.")
public class ColumnExpression
implements Directive,
Lineage {
    public static final String NAME = "set-column";
    private String column;
    private String expression;
    private EL el;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("expression", TokenType.EXPRESSION);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.expression = ((Expression)args.value("expression")).value();
        try {
            this.el = EL.compile(this.expression);
        }
        catch (ELException e) {
            throw new DirectiveParseException(NAME, e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ELContext ctx = new ELContext(context, this.el, row);
            try {
                ELResult result = this.el.execute(ctx);
                int idx = row.find(this.column);
                if (idx == -1) {
                    row.add(this.column, result.getObject());
                    continue;
                }
                row.setValue(idx, result.getObject());
            }
            catch (ELException e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        Mutation.Builder builder = Mutation.builder().readable("Mapped result of expression '%s' to column '%s'", new Object[]{this.expression, this.column});
        builder.relation(Many.of(this.el.variables()), this.column);
        this.el.variables().forEach(col -> {
            if (!col.equals(this.column)) {
                builder.relation(col, col);
            }
        });
        return builder.build();
    }

    public List<EntityCountMetric> getCountMetrics() {
        EntityCountMetric jexlCategoryMetric = JexlCategoryMetricUtils.getJexlCategoryMetric(this.el.getScriptParsedText());
        return jexlCategoryMetric == null ? null : ImmutableList.of((Object)jexlCategoryMetric);
    }
}

