/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONObject;

@Plugin(type="directive")
@Name(value="filter-by-regex")
@Categories(categories={"row", "data-quality"})
@Description(value="Filters rows if the regex is matched or not matched.")
public class RecordRegexFilter
implements Directive,
Lineage {
    public static final String NAME = "filter-by-regex";
    private String column;
    private Pattern pattern;
    private boolean matched = false;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("match-type", TokenType.IDENTIFIER);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("regex", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        String matchType = ((Identifier)args.value("match-type")).value();
        if (matchType.equalsIgnoreCase("if-matched")) {
            this.matched = true;
        } else if (matchType.equalsIgnoreCase("if-not-matched")) {
            this.matched = false;
        } else {
            throw new DirectiveParseException(NAME, "Match type specified is not 'if-matched' or 'if-not-matched'");
        }
        this.column = ((ColumnName)args.value("column")).value();
        String regex = ((Text)args.value("regex")).value();
        this.pattern = !regex.equalsIgnoreCase("null") && !regex.isEmpty() ? Pattern.compile(regex) : null;
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        if (this.pattern == null) {
            return rows;
        }
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                Object object = row.getValue(idx);
                if (object == null) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String', 'JSONObject' or 'Number'.", this.column));
                }
                if (object instanceof JSONObject) {
                    if (this.pattern == null && JSONObject.NULL.equals(object)) {
                        continue;
                    }
                } else if (object instanceof String) {
                    if (this.matchPattern((String)row.getValue(idx))) {
                        continue;
                    }
                } else if (object instanceof Number) {
                    if (this.matchPattern(row.getValue(idx).toString())) {
                        continue;
                    }
                } else {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String', 'JSONObject' or 'Number'.", this.column, object.getClass().getSimpleName()));
                }
                results.add(row);
                continue;
            }
            results.add(row);
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Filtered column '%s' based on whether the expression '%s' %s ", new Object[]{this.column, this.pattern, this.matched ? "matched" : "not matched"}).relation(this.column, this.column).build();
    }

    private boolean matchPattern(String value) {
        boolean matches = this.pattern.matcher(value).matches();
        if (!this.matched) {
            matches = !matches;
        }
        return matches;
    }
}

