/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Plugin(type="directive")
@Name(value="filter-empty-or-null")
@Categories(categories={"row", "data-quality"})
@Description(value="Filters row that have empty or null columns.")
public class RecordMissingOrNullFilter
implements Directive,
Lineage {
    public static final String NAME = "filter-empty-or-null";
    private String[] columns;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        List cols = ((ColumnNameList)args.value("column")).value();
        this.columns = new String[cols.size()];
        this.columns = cols.toArray(this.columns);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            boolean missingOrNull = true;
            for (String column : this.columns) {
                int idx = row.find(column.trim());
                if (idx != -1) {
                    Object value = row.getValue(idx);
                    if (value == null) continue;
                    missingOrNull = false;
                    continue;
                }
                results.add(row);
            }
            if (missingOrNull) continue;
            results.add(row);
        }
        return results;
    }

    public Mutation lineage() {
        List<String> cols = Arrays.asList(this.columns);
        Mutation.Builder builder = Mutation.builder().readable("Filtered null or empty records based on check on columns '%s'", new Object[]{cols});
        cols.forEach(column -> builder.relation(column, column));
        return builder.build();
    }
}

