/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import com.google.common.collect.ImmutableList;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.EntityCountMetric;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.Expression;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.expression.EL;
import io.cdap.wrangler.expression.ELContext;
import io.cdap.wrangler.expression.ELException;
import io.cdap.wrangler.expression.ELResult;
import io.cdap.wrangler.metrics.JexlCategoryMetricUtils;
import java.util.List;

@Plugin(type="directive")
@Name(value="fail")
@Categories(categories={"row", "data-quality"})
@Description(value="Fails when the condition is evaluated to true.")
public class Fail
implements Directive,
Lineage {
    public static final String NAME = "fail";
    private String condition;
    private EL el;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("condition", TokenType.EXPRESSION);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        Expression expression = (Expression)args.value("condition");
        if (expression.value().isEmpty()) {
            throw new DirectiveParseException(NAME, "No condition has been specified. Make sure condition is provided");
        }
        this.condition = expression.value();
        try {
            this.el = EL.compile(this.condition);
        }
        catch (ELException e) {
            throw new DirectiveParseException(NAME, e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ELContext ctx = new ELContext(context, this.el, row);
            try {
                ELResult result = this.el.execute(ctx);
                if (!result.getBoolean().booleanValue()) continue;
                throw new DirectiveExecutionException(NAME, String.format("Condition '%s' evaluated to true. Terminating processing.", this.condition));
            }
            catch (ELException e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        Mutation.Builder builder = Mutation.builder().readable(String.format("Pipeline set to fail based on condition '%s'", this.condition), new Object[0]);
        this.el.variables().forEach(col -> builder.relation(col, col));
        return builder.build();
    }

    public List<EntityCountMetric> getCountMetrics() {
        EntityCountMetric jexlCategoryMetric = JexlCategoryMetricUtils.getJexlCategoryMetric(this.el.getScriptParsedText());
        return jexlCategoryMetric == null ? null : ImmutableList.of((Object)jexlCategoryMetric);
    }
}

