/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

@Plugin(type="directive")
@Name(value="parse-as-simple-date")
@Categories(categories={"parser", "date"})
@Description(value="Parses a column as date using format.")
public class ParseSimpleDate
implements Directive,
Lineage {
    public static final String NAME = "parse-as-simple-date";
    private String column;
    private SimpleDateFormat formatter;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("format", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        String format = ((Text)args.value("format")).value();
        this.formatter = new SimpleDateFormat(format);
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gc.setGregorianChange(new Date(Long.MIN_VALUE));
        this.formatter.setCalendar(gc);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || (object = row.getValue(idx)) == null || object instanceof ZonedDateTime) continue;
            if (object instanceof String) {
                try {
                    Date date = this.formatter.parse(object.toString());
                    ZonedDateTime zonedDateTime = ZonedDateTime.from(date.toInstant().atZone(ZoneId.ofOffset("UTC", ZoneOffset.UTC)));
                    row.setValue(idx, (Object)zonedDateTime);
                    continue;
                }
                catch (ParseException e) {
                    throw new ErrorRowException(NAME, String.format("Failed to parse '%s' with pattern '%s'", object, this.formatter.toPattern()), 1);
                }
            }
            throw new ErrorRowException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()), 2);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as date using user specified format '%s'", new Object[]{this.column, this.formatter.toPattern()}).relation(this.column, this.column).build();
    }
}

