/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;

@Plugin(type="directive")
@Name(value="parse-as-datetime")
@Categories(categories={"parser", "datetime"})
@Description(value="Parse a column value as datetime using the given format")
public class ParseDateTime
implements Directive,
Lineage {
    public static final String NAME = "parse-as-datetime";
    private static final String COLUMN = "column";
    private static final String FORMAT = "format";
    private String column;
    private String format;
    private DateTimeFormatter formatter;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define(COLUMN, TokenType.COLUMN_NAME);
        builder.define(FORMAT, TokenType.TEXT, false);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value(COLUMN)).value();
        this.format = args.value(FORMAT).value().toString();
        try {
            this.formatter = DateTimeFormatter.ofPattern(this.format);
        }
        catch (IllegalArgumentException exception) {
            throw new DirectiveParseException(NAME, String.format("'%s' is an invalid datetime format.", this.format), (Throwable)exception);
        }
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws ErrorRowException {
        for (Row row : rows) {
            Object value;
            int idx = row.find(this.column);
            if (idx == -1 || (value = row.getValue(idx)) == null || value instanceof LocalDateTime) continue;
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(value.toString(), this.formatter);
                row.setValue(idx, (Object)localDateTime);
            }
            catch (DateTimeParseException exception) {
                throw new ErrorRowException(NAME, String.format("Value %s for column %s is not in expected format %s", value.toString(), this.column, this.format), 2, (Throwable)exception);
            }
        }
        return rows;
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' in format '%s' as datetime", new Object[]{this.column, this.format}).relation(this.column, this.column).build();
    }
}

