/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.date;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;

@Plugin(type="directive")
@Name(value="diff-date")
@Categories(categories={"date"})
@Description(value="Calculates the difference in milliseconds between two Date objects.Positive if <column2> earlier. Must use 'parse-as-date' or 'parse-as-simple-date' first.")
public class DiffDate
implements Directive,
Lineage {
    public static final String NAME = "diff-date";
    private String column1;
    private String column2;
    private String destCol;
    private final ZonedDateTime date = ZonedDateTime.now(ZoneId.ofOffset("UTC", ZoneOffset.UTC));

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column1", TokenType.COLUMN_NAME);
        builder.define("column2", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column1 = ((ColumnName)args.value("column1")).value();
        this.column2 = ((ColumnName)args.value("column2")).value();
        this.destCol = ((ColumnName)args.value("destination")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ZonedDateTime date1 = this.getDate(row, this.column1);
            ZonedDateTime date2 = this.getDate(row, this.column2);
            if (date1 != null && date2 != null) {
                row.addOrSet(this.destCol, (Object)(date1.toInstant().toEpochMilli() - date2.toInstant().toEpochMilli()));
                continue;
            }
            row.addOrSet(this.destCol, null);
        }
        return rows;
    }

    private ZonedDateTime getDate(Row row, String colName) throws DirectiveExecutionException {
        if (colName.equalsIgnoreCase("now")) {
            return this.date;
        }
        int idx = row.find(colName);
        if (idx == -1) {
            throw new DirectiveExecutionException(NAME, "Column '" + colName + "' does not exist.");
        }
        Object o = row.getValue(idx);
        if (o == null || !(o instanceof ZonedDateTime)) {
            return null;
        }
        return (ZonedDateTime)o;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Calculated difference between dates in column '%s' and '%s' and store in '%s'", new Object[]{this.column1, this.column2, this.destCol}).relation(Many.columns((String[])new String[]{this.column1, this.column2}), this.destCol).relation(this.column1, this.column1).relation(this.column2, this.column2).build();
    }
}

