/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.SchemaResolutionContext;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import java.util.stream.Collectors;

@Plugin(type="directive")
@Name(value="swap")
@Categories(categories={"column"})
@Description(value="Swaps the column names of two columns.")
public class Swap
implements Directive,
Lineage {
    public static final String NAME = "swap";
    private String left;
    private String right;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("left", TokenType.COLUMN_NAME);
        builder.define("right", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.left = ((ColumnName)args.value("left")).value();
        this.right = ((ColumnName)args.value("right")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int sidx = row.find(this.left);
            int didx = row.find(this.right);
            if (sidx == -1) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.left));
            }
            if (didx == -1) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.right));
            }
            row.setColumn(sidx, this.right);
            row.setColumn(didx, this.left);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Swapped columns '%s' and '%s'", new Object[]{this.left, this.right}).relation(Many.of((String[])new String[]{this.left, this.right}), Many.of((String[])new String[]{this.right, this.left})).build();
    }

    public Schema getOutputSchema(SchemaResolutionContext context) {
        Schema inputSchema = context.getInputSchema();
        return Schema.recordOf((String)"outputSchema", (Iterable)inputSchema.getFields().stream().map(field -> field.getName().equals(this.left) ? Schema.Field.of((String)this.right, (Schema)field.getSchema()) : (field.getName().equals(this.right) ? Schema.Field.of((String)this.left, (Schema)field.getSchema()) : field)).collect(Collectors.toList()));
    }
}

