/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.SchemaResolutionContext;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.utils.ColumnConverter;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;

@Plugin(type="directives")
@Name(value="set-type")
@Categories(categories={"column"})
@Description(value="Converting data type of a column. Optional arguments scale and rounding-mode are used only when type is decimal.")
public final class SetType
implements Directive,
Lineage {
    public static final String NAME = "set-type";
    private String col;
    private String type;
    private Integer scale;
    private RoundingMode roundingMode;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("type", TokenType.IDENTIFIER);
        builder.define("scale", TokenType.NUMERIC, true);
        builder.define("rounding-mode", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col = ((ColumnName)args.value("column")).value();
        this.type = ((Identifier)args.value("type")).value();
        if (this.type.equalsIgnoreCase("decimal")) {
            Integer n = this.scale = args.contains("scale") ? Integer.valueOf(((Numeric)args.value("scale")).value().intValue()) : null;
            if (this.scale == null && args.contains("rounding-mode")) {
                throw new DirectiveParseException("'rounding-mode' can only be specified when a 'scale' is set");
            }
            try {
                this.roundingMode = args.contains("rounding-mode") ? RoundingMode.valueOf(((Text)args.value("rounding-mode")).value()) : (this.scale == null ? RoundingMode.UNNECESSARY : RoundingMode.HALF_EVEN);
            }
            catch (IllegalArgumentException e) {
                throw new DirectiveParseException(String.format("Specified rounding-mode '%s' is not a valid Java rounding mode", args.value("rounding-mode").value()), (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ColumnConverter.convertType(NAME, row, this.col, this.type, this.scale, this.roundingMode);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Changed the column '%s' to type '%s'", new Object[]{this.col, this.type}).relation(this.col, this.col).build();
    }

    public Schema getOutputSchema(SchemaResolutionContext context) {
        Schema inputSchema = context.getInputSchema();
        if (this.type.equalsIgnoreCase("decimal") && this.scale == null) {
            return null;
        }
        return Schema.recordOf((String)"outputSchema", (Iterable)inputSchema.getFields().stream().map(field -> {
            try {
                return field.getName().equals(this.col) ? Schema.Field.of((String)this.col, (Schema)ColumnConverter.getSchemaForType(this.type, this.scale)) : field;
            }
            catch (DirectiveParseException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
    }
}

