/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="flatten-record")
@Categories(categories={"column"})
@Description(value="Flattens a record into individual columns.")
public class FlattenRecord
implements Directive {
    public static final String NAME = "flatten-record";
    private String[] columns;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("columns", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        List cols = ((ColumnNameList)args.value("columns")).value();
        this.columns = new String[cols.size()];
        this.columns = cols.toArray(this.columns);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            for (String column : this.columns) {
                Object object;
                int idx = row.find(column);
                if (idx == -1 || (object = row.getValue(idx)) == null) continue;
                if (!(object instanceof Row)) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'Record'.", column, object.getClass().getSimpleName()));
                }
                Row rowColumns = (Row)object;
                for (Pair field : rowColumns.getFields()) {
                    String columnName = String.format("%s_%s", column, field.getFirst());
                    row.addOrSet(columnName, field.getSecond());
                }
            }
            results.add(row);
        }
        return results;
    }
}

