/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;

@Plugin(type="directive")
@Name(value="drop")
@Categories(categories={"column"})
@Description(value="Drop one or more columns.")
public class Drop
implements Directive,
Lineage {
    public static final String NAME = "drop";
    private List<String> columns;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        ColumnNameList cols = (ColumnNameList)args.value("column");
        this.columns = cols.value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            for (String column : this.columns) {
                int idx = row.find(column.trim());
                if (idx == -1) continue;
                row.remove(idx);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Dropped columns %s", new Object[]{this.columns}).drop(Many.of(this.columns)).build();
    }
}

