/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Plugin(type="directive")
@Name(value="create-record")
@Categories(categories={"column"})
@Description(value="Creates Column of type Record .")
public class CreateRecord
implements Directive,
Lineage {
    public static final String NAME = "create-record";
    private String targetColumn;
    private String[] columns;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("target_column", TokenType.COLUMN_NAME);
        builder.define("columns", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        List cols = ((ColumnNameList)args.value("columns")).value();
        this.targetColumn = args.value("target_column").value().toString();
        this.columns = cols.toArray(new String[0]);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            Row newRecord = new Row();
            for (String columnName : this.columns) {
                Object columnValue = row.getValue(columnName);
                if (columnValue == null) continue;
                newRecord.addOrSet(columnName, columnValue);
            }
            Row newRow = new Row(row);
            newRow.addOrSet(this.targetColumn, (Object)newRecord);
            results.add(newRow);
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Created column based on values in columns '%s''", Arrays.asList(this.columns)).relation(Many.columns((String[])this.columns), this.targetColumn).build();
    }
}

