/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.SchemaResolutionContext;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import java.util.stream.Collectors;
import org.unix4j.Unix4j;
import org.unix4j.builder.Unix4jCommandBuilder;

@Plugin(type="directives")
@Name(value="columns-replace")
@Categories(categories={"column"})
@Description(value="Modifies column names in bulk using a sed-format expression.")
public class ColumnsReplace
implements Directive,
Lineage {
    public static final String NAME = "columns-replace";
    private String sed;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("sed-expression", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.sed = ((Text)args.value("sed-expression")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            for (int i = 0; i < row.width(); ++i) {
                String name = row.getColumn(i);
                try {
                    row.setColumn(i, this.getSedReplacedColumnName(name));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
                }
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Reformatted all columns using expression '%s'", new Object[]{this.sed}).all(Many.of((String[])new String[0])).build();
    }

    public Schema getOutputSchema(SchemaResolutionContext context) {
        Schema inputSchema = context.getInputSchema();
        return Schema.recordOf((String)"outputSchema", (Iterable)inputSchema.getFields().stream().map(field -> Schema.Field.of((String)this.getSedReplacedColumnName(field.getName()), (Schema)field.getSchema())).collect(Collectors.toList()));
    }

    private String getSedReplacedColumnName(String colName) {
        Unix4jCommandBuilder builder = Unix4j.echo((String[])new String[]{colName}).sed(this.sed);
        return builder.toStringResult();
    }
}

