/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.SchemaResolutionContext;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import java.util.stream.Collectors;

@Plugin(type="directive")
@Name(value="change-column-case")
@Categories(categories={"column"})
@Description(value="Changes the case of column names to either lowercase or uppercase.")
public class ChangeColCaseNames
implements Directive,
Lineage {
    public static final String NAME = "change-column-case";
    private boolean toLower;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("case", TokenType.IDENTIFIER, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        Identifier identifier;
        String casing;
        this.toLower = true;
        if (args.contains("case") && ((casing = (identifier = (Identifier)args.value("case")).value()).equalsIgnoreCase("upper") || casing.equalsIgnoreCase("uppercase"))) {
            this.toLower = false;
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            for (int i = 0; i < row.width(); ++i) {
                String name = row.getColumn(i);
                if (this.toLower) {
                    row.setColumn(i, name.toLowerCase());
                    continue;
                }
                row.setColumn(i, name.toUpperCase());
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Changed all column names to ", new Object[]{this.toLower ? "'lowercase'" : "'uppercase'"}).all(Many.of((String[])new String[0])).build();
    }

    public Schema getOutputSchema(SchemaResolutionContext context) {
        Schema inputSchema = context.getInputSchema();
        return Schema.recordOf((String)"outputSchema", (Iterable)inputSchema.getFields().stream().map(field -> {
            String fieldName = this.toLower ? field.getName().toLowerCase() : field.getName().toUpperCase();
            return Schema.Field.of((String)fieldName, (Schema)field.getSchema());
        }).collect(Collectors.toList()));
    }
}

